/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DatabaseException;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ResultConsumedException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static ServiceUnavailableException newConnectionTerminatedError(String reason) {
        if (reason == null) {
            return ErrorUtil.newConnectionTerminatedError();
        }
        return new ServiceUnavailableException("Connection to the database terminated. " + reason);
    }

    public static ServiceUnavailableException newConnectionTerminatedError() {
        return new ServiceUnavailableException("Connection to the database terminated. Please ensure that your database is listening on the correct host and port and that you have compatible encryption settings both on Neo4j server and driver. Note that the default encryption setting has changed in Neo4j 4.0.");
    }

    public static ResultConsumedException newResultConsumedError() {
        return new ResultConsumedException("Cannot access records on this result any more as the result has already been consumed or the query runner where the result is created has already been closed.");
    }

    public static Neo4jException newNeo4jError(String code, String message) {
        String classification;
        switch (classification = ErrorUtil.extractClassification(code)) {
            case "ClientError": {
                if (code.equalsIgnoreCase("Neo.ClientError.Security.Unauthorized")) {
                    return new AuthenticationException(code, message);
                }
                if (code.equalsIgnoreCase("Neo.ClientError.Database.DatabaseNotFound")) {
                    return new FatalDiscoveryException(code, message);
                }
                if (code.equalsIgnoreCase("Neo.ClientError.Security.AuthorizationExpired")) {
                    return new AuthorizationExpiredException(code, message);
                }
                return new ClientException(code, message);
            }
            case "TransientError": {
                return new TransientException(code, message);
            }
        }
        return new DatabaseException(code, message);
    }

    public static boolean isFatal(Throwable error) {
        if (error instanceof Neo4jException) {
            if (ErrorUtil.isProtocolViolationError((Neo4jException)error)) {
                return true;
            }
            if (ErrorUtil.isClientOrTransientError((Neo4jException)error)) {
                return false;
            }
        }
        return true;
    }

    public static void rethrowAsyncException(ExecutionException e) {
        Throwable error = e.getCause();
        InternalExceptionCause internalCause = new InternalExceptionCause(error.getStackTrace());
        error.addSuppressed(internalCause);
        StackTraceElement[] currentStackTrace = (StackTraceElement[])Stream.of(Thread.currentThread().getStackTrace()).skip(2L).toArray(StackTraceElement[]::new);
        error.setStackTrace(currentStackTrace);
        PlatformDependent.throwException(error);
    }

    private static boolean isProtocolViolationError(Neo4jException error) {
        String errorCode = error.code();
        return errorCode != null && errorCode.startsWith("Neo.ClientError.Request");
    }

    private static boolean isClientOrTransientError(Neo4jException error) {
        String errorCode = error.code();
        return errorCode != null && (errorCode.contains("ClientError") || errorCode.contains("TransientError"));
    }

    private static String extractClassification(String code) {
        String[] parts = code.split("\\.");
        if (parts.length < 2) {
            return "";
        }
        return parts[1];
    }

    public static void addSuppressed(Throwable mainError, Throwable error) {
        if (mainError != error) {
            mainError.addSuppressed(error);
        }
    }

    public static Throwable getRootCause(Throwable error) {
        Objects.requireNonNull(error);
        Throwable cause = error.getCause();
        if (cause == null) {
            return error;
        }
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private static class InternalExceptionCause
    extends RuntimeException {
        InternalExceptionCause(StackTraceElement[] stackTrace) {
            this.setStackTrace(stackTrace);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

