/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v4;

import org.neo4j.driver.Query;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.cursor.ResultCursorFactoryImpl;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullHandlers;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.MessageFormatV4;
import org.neo4j.driver.internal.spi.Connection;

public class BoltProtocolV4
extends BoltProtocolV3 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(4, 0);
    public static final BoltProtocol INSTANCE = new BoltProtocolV4();

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV4();
    }

    @Override
    protected ResultCursorFactory buildResultCursorFactory(Connection connection, Query query, BookmarkHolder bookmarkHolder, UnmanagedTransaction tx, RunWithMetadataMessage runMessage, boolean waitForRunResponse, long fetchSize) {
        RunResponseHandler runHandler = new RunResponseHandler(METADATA_EXTRACTOR);
        PullAllResponseHandler pullAllHandler = PullHandlers.newBoltV4AutoPullHandler(query, runHandler, connection, bookmarkHolder, tx, fetchSize);
        PullResponseHandler pullHandler = PullHandlers.newBoltV4BasicPullHandler(query, runHandler, connection, bookmarkHolder, tx);
        return new ResultCursorFactoryImpl(connection, runMessage, runHandler, pullHandler, pullAllHandler, waitForRunResponse);
    }

    @Override
    protected void verifyDatabaseNameBeforeTransaction(DatabaseName databaseName) {
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }
}

