/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.neo4j.driver.Record;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.summary.ResultSummary;

public class RxResultCursorImpl
implements RxResultCursor {
    static final BiConsumer<Record, Throwable> DISCARD_RECORD_CONSUMER = (record, throwable) -> {};
    private final RunResponseHandler runHandler;
    private final PullResponseHandler pullHandler;
    private final Throwable runResponseError;
    private final CompletableFuture<ResultSummary> summaryFuture = new CompletableFuture();
    private boolean resultConsumed;
    private RecordConsumerStatus consumerStatus = RecordConsumerStatus.NOT_INSTALLED;

    public RxResultCursorImpl(RunResponseHandler runHandler, PullResponseHandler pullHandler) {
        this(null, runHandler, pullHandler);
    }

    public RxResultCursorImpl(Throwable runError, RunResponseHandler runHandler, PullResponseHandler pullHandler) {
        Objects.requireNonNull(runHandler);
        Objects.requireNonNull(pullHandler);
        this.assertRunResponseArrived(runHandler);
        this.runResponseError = runError;
        this.runHandler = runHandler;
        this.pullHandler = pullHandler;
        this.installSummaryConsumer();
    }

    @Override
    public List<String> keys() {
        return this.runHandler.queryKeys();
    }

    @Override
    public void installRecordConsumer(BiConsumer<Record, Throwable> recordConsumer) {
        if (this.resultConsumed) {
            throw ErrorUtil.newResultConsumedError();
        }
        if (this.consumerStatus.isInstalled()) {
            return;
        }
        this.consumerStatus = recordConsumer == DISCARD_RECORD_CONSUMER ? RecordConsumerStatus.DISCARD_INSTALLED : RecordConsumerStatus.INSTALLED;
        this.pullHandler.installRecordConsumer(recordConsumer);
        this.assertRunCompletedSuccessfully();
    }

    public void request(long n) {
        this.pullHandler.request(n);
    }

    public void cancel() {
        this.pullHandler.cancel();
    }

    @Override
    public CompletionStage<Throwable> discardAllFailureAsync() {
        return this.summaryAsync().thenApply(summary -> null).exceptionally(error -> error);
    }

    @Override
    public CompletionStage<Throwable> pullAllFailureAsync() {
        if (this.consumerStatus.isInstalled() && !this.isDone()) {
            return CompletableFuture.completedFuture(new TransactionNestingException("You cannot run another query or begin a new transaction in the same session before you've fully consumed the previous run result."));
        }
        return this.discardAllFailureAsync();
    }

    @Override
    public CompletionStage<ResultSummary> summaryAsync() {
        if (!this.isDone() && !this.resultConsumed) {
            this.installRecordConsumer(DISCARD_RECORD_CONSUMER);
            this.cancel();
            this.resultConsumed = true;
        }
        return this.summaryFuture;
    }

    @Override
    public boolean isDone() {
        return this.summaryFuture.isDone();
    }

    private void assertRunCompletedSuccessfully() {
        if (this.runResponseError != null) {
            this.pullHandler.onFailure(this.runResponseError);
        }
    }

    private void installSummaryConsumer() {
        this.pullHandler.installSummaryConsumer((summary, error) -> {
            if (error != null && this.consumerStatus.isDiscardConsumer()) {
                this.summaryFuture.completeExceptionally((Throwable)error);
            } else if (summary != null) {
                this.summaryFuture.complete((ResultSummary)summary);
            }
        });
    }

    private void assertRunResponseArrived(RunResponseHandler runHandler) {
        if (!runHandler.runFuture().isDone()) {
            throw new IllegalStateException("Should wait for response of RUN before allowing PULL.");
        }
    }

    static enum RecordConsumerStatus {
        NOT_INSTALLED(false, false),
        INSTALLED(true, false),
        DISCARD_INSTALLED(true, true);

        private final boolean isInstalled;
        private final boolean isDiscardConsumer;

        private RecordConsumerStatus(boolean isInstalled, boolean isDiscardConsumer) {
            this.isInstalled = isInstalled;
            this.isDiscardConsumer = isDiscardConsumer;
        }

        boolean isInstalled() {
            return this.isInstalled;
        }

        boolean isDiscardConsumer() {
            return this.isDiscardConsumer;
        }
    }
}

