/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.internal.InternalSession;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.async.InternalAsyncSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.reactive.InternalRxSession;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.types.TypeSystem;

public class InternalDriver
implements Driver {
    private final SecurityPlan securityPlan;
    private final SessionFactory sessionFactory;
    private final Logger log;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final MetricsProvider metricsProvider;

    InternalDriver(SecurityPlan securityPlan, SessionFactory sessionFactory, MetricsProvider metricsProvider, Logging logging) {
        this.securityPlan = securityPlan;
        this.sessionFactory = sessionFactory;
        this.metricsProvider = metricsProvider;
        this.log = logging.getLog(Driver.class.getSimpleName());
    }

    @Override
    public Session session() {
        return new InternalSession(this.newSession(SessionConfig.defaultConfig()));
    }

    @Override
    public Session session(SessionConfig sessionConfig) {
        return new InternalSession(this.newSession(sessionConfig));
    }

    @Override
    public RxSession rxSession() {
        return new InternalRxSession(this.newSession(SessionConfig.defaultConfig()));
    }

    @Override
    public RxSession rxSession(SessionConfig sessionConfig) {
        return new InternalRxSession(this.newSession(sessionConfig));
    }

    @Override
    public AsyncSession asyncSession() {
        return new InternalAsyncSession(this.newSession(SessionConfig.defaultConfig()));
    }

    @Override
    public AsyncSession asyncSession(SessionConfig sessionConfig) {
        return new InternalAsyncSession(this.newSession(sessionConfig));
    }

    @Override
    public Metrics metrics() {
        return this.metricsProvider.metrics();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metricsProvider.isMetricsEnabled();
    }

    @Override
    public boolean isEncrypted() {
        this.assertOpen();
        return this.securityPlan.requiresEncryption();
    }

    @Override
    public void close() {
        Futures.blockingGet(this.closeAsync());
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        if (this.closed.compareAndSet(false, true)) {
            this.log.info("Closing driver instance %s", this.hashCode());
            return this.sessionFactory.close();
        }
        return Futures.completedWithNull();
    }

    @Override
    public final TypeSystem defaultTypeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    @Override
    public CompletionStage<Void> verifyConnectivityAsync() {
        return this.sessionFactory.verifyConnectivity();
    }

    @Override
    public void verifyConnectivity() {
        Futures.blockingGet(this.verifyConnectivityAsync());
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private static RuntimeException driverCloseException() {
        return new IllegalStateException("This driver instance has already been closed");
    }

    public NetworkSession newSession(SessionConfig config) {
        this.assertOpen();
        NetworkSession session = this.sessionFactory.newInstance(config);
        if (this.closed.get()) {
            throw InternalDriver.driverCloseException();
        }
        return session;
    }

    private void assertOpen() {
        if (this.closed.get()) {
            throw InternalDriver.driverCloseException();
        }
    }
}

