/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Disposable;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.neo4j.driver.internal.shaded.reactor.util.concurrent.WaitStrategy;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MonoProcessor<O>
extends Mono<O>
implements Processor<O, O>,
CoreSubscriber<O>,
Disposable,
Subscription,
Scannable,
LongSupplier {
    final WaitStrategy waitStrategy;
    volatile NextInner<O>[] subscribers;
    static final AtomicReferenceFieldUpdater<MonoProcessor, NextInner[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(MonoProcessor.class, NextInner[].class, "subscribers");
    static final NextInner[] EMPTY = new NextInner[0];
    static final NextInner[] TERMINATED = new NextInner[0];
    static final NextInner[] EMPTY_WITH_SOURCE = new NextInner[0];
    Publisher<? extends O> source;
    Throwable error;
    O value;
    volatile Subscription subscription;
    static final AtomicReferenceFieldUpdater<MonoProcessor, Subscription> UPSTREAM = AtomicReferenceFieldUpdater.newUpdater(MonoProcessor.class, Subscription.class, "subscription");

    public static <T> MonoProcessor<T> create() {
        return new MonoProcessor(null);
    }

    public static <T> MonoProcessor<T> create(WaitStrategy waitStrategy) {
        return new MonoProcessor(null, waitStrategy);
    }

    MonoProcessor(@Nullable Publisher<? extends O> source) {
        this(source, WaitStrategy.sleeping());
    }

    MonoProcessor(@Nullable Publisher<? extends O> source, WaitStrategy waitStrategy) {
        this.waitStrategy = Objects.requireNonNull(waitStrategy, "waitStrategy");
        this.source = source;
        SUBSCRIBERS.lazySet(this, source != null ? EMPTY_WITH_SOURCE : EMPTY);
    }

    public final void cancel() {
        if (this.isTerminated()) {
            return;
        }
        Subscription s = UPSTREAM.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            return;
        }
        this.source = null;
        if (s != null) {
            s.cancel();
        }
    }

    @Override
    public void dispose() {
        NextInner[] a;
        Subscription s = UPSTREAM.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            return;
        }
        this.source = null;
        if (s != null) {
            s.cancel();
        }
        if ((a = SUBSCRIBERS.getAndSet(this, TERMINATED)) != TERMINATED) {
            CancellationException e = new CancellationException("Disposed");
            this.error = e;
            this.value = null;
            for (NextInner as : a) {
                as.onError(e);
            }
        }
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    @Nullable
    public O block() {
        return this.block(WaitStrategy.NOOP_SPIN_OBSERVER);
    }

    @Override
    @Nullable
    public O block(Duration timeout) {
        long delay = System.nanoTime() + timeout.toNanos();
        Runnable spinObserver = () -> {
            if (delay < System.nanoTime()) {
                WaitStrategy.alert();
            }
        };
        return this.block(spinObserver);
    }

    @Nullable
    O block(Runnable spinObserver) {
        try {
            if (!this.isPending()) {
                return this.peek();
            }
            this.connect();
            try {
                long endState = this.waitStrategy.waitFor(3L, this, spinObserver);
                switch ((int)endState) {
                    case 3: {
                        return this.value;
                    }
                    case 4: {
                        return null;
                    }
                    case 5: {
                        RuntimeException re = Exceptions.propagate(this.error);
                        re = Exceptions.addSuppressed(re, (Throwable)new Exception("Mono#block terminated with an error"));
                        throw re;
                    }
                }
                throw new IllegalStateException("Mono has been cancelled");
            }
            catch (RuntimeException ce) {
                if (WaitStrategy.isAlert(ce)) {
                    this.cancel();
                    throw new IllegalStateException("Timeout on Mono blocking read");
                }
                throw ce;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread Interruption on Mono blocking read");
        }
    }

    @Override
    public long getAsLong() {
        NextInner<O>[] inners = this.subscribers;
        if (inners == TERMINATED) {
            if (this.error != null) {
                return 5L;
            }
            if (this.value == null) {
                return 4L;
            }
            return 3L;
        }
        if (this.subscription == Operators.cancelledSubscription()) {
            return -1L;
        }
        if (this.subscribers != EMPTY && this.subscribers != EMPTY_WITH_SOURCE) {
            return 2L;
        }
        return 0L;
    }

    @Nullable
    public final Throwable getError() {
        return this.isTerminated() ? this.error : null;
    }

    public boolean isCancelled() {
        return this.subscription == Operators.cancelledSubscription() && !this.isTerminated();
    }

    public final boolean isError() {
        return this.getError() != null;
    }

    public final boolean isSuccess() {
        return this.isTerminated() && this.error == null;
    }

    public final boolean isTerminated() {
        return this.subscribers == TERMINATED;
    }

    @Override
    public boolean isDisposed() {
        return this.isTerminated() || this.isCancelled();
    }

    public final void onComplete() {
        this.onNext(null);
    }

    public final void onError(Throwable cause) {
        Objects.requireNonNull(cause, "onError cannot be null");
        if (UPSTREAM.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            Operators.onErrorDroppedMulticast(cause);
            return;
        }
        this.error = cause;
        this.value = null;
        this.source = null;
        for (NextInner as : SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            as.onError(cause);
        }
        this.waitStrategy.signalAllWhenBlocking();
    }

    public final void onNext(@Nullable O value) {
        Subscription s = UPSTREAM.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            if (value != null) {
                Operators.onNextDroppedMulticast(value);
            }
            return;
        }
        this.value = value;
        Publisher<? extends O> parent = this.source;
        this.source = null;
        NextInner[] array = SUBSCRIBERS.getAndSet(this, TERMINATED);
        if (value == null) {
            for (NextInner as : array) {
                as.onComplete();
            }
        } else {
            if (s != null && !(parent instanceof Mono)) {
                s.cancel();
            }
            for (NextInner as : array) {
                as.complete(value);
            }
        }
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public final void onSubscribe(Subscription subscription) {
        if (Operators.setOnce(UPSTREAM, this, subscription)) {
            subscription.request(Long.MAX_VALUE);
        }
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return Stream.of(this.subscribers);
    }

    @Nullable
    public O peek() {
        if (!this.isTerminated()) {
            return null;
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.error != null) {
            RuntimeException re = Exceptions.propagate(this.error);
            re = Exceptions.addSuppressed(re, (Throwable)new Exception("Mono#peek terminated with an error"));
            throw re;
        }
        return null;
    }

    public final void request(long n) {
        Operators.validate(n);
    }

    @Override
    public void subscribe(CoreSubscriber<? super O> actual) {
        NextInner<O> as = new NextInner<O>(actual, this);
        actual.onSubscribe(as);
        if (this.add(as)) {
            if (as.isCancelled()) {
                this.remove(as);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                actual.onError(ex);
            } else {
                O v = this.value;
                if (v != null) {
                    as.complete(v);
                } else {
                    as.onComplete();
                }
            }
        }
    }

    void connect() {
        Publisher<? extends O> parent = this.source;
        if (parent != null && SUBSCRIBERS.compareAndSet(this, EMPTY_WITH_SOURCE, EMPTY)) {
            parent.subscribe((Subscriber)this);
        }
    }

    @Override
    public Context currentContext() {
        return Operators.multiSubscribersContext(this.subscribers);
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        boolean t = this.isTerminated();
        if (key == Scannable.Attr.TERMINATED) {
            return t;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.subscription;
        }
        if (key == Scannable.Attr.ERROR) {
            return this.error;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return Integer.MAX_VALUE;
        }
        if (key == Scannable.Attr.CANCELLED) {
            return this.isCancelled();
        }
        return null;
    }

    final boolean isPending() {
        return !this.isTerminated();
    }

    public final long downstreamCount() {
        return this.subscribers.length;
    }

    public final boolean hasDownstreams() {
        return this.downstreamCount() != 0L;
    }

    boolean add(NextInner<O> ps) {
        NextInner[] b;
        NextInner<O>[] a;
        do {
            if ((a = this.subscribers) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new NextInner[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        Publisher<? extends O> parent = this.source;
        if (parent != null && a == EMPTY_WITH_SOURCE) {
            parent.subscribe((Subscriber)this);
        }
        return true;
    }

    void remove(NextInner<O> ps) {
        NextInner[] b;
        NextInner<O>[] a;
        do {
            int n;
            if ((n = (a = this.subscribers).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new NextInner[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
    }

    static final class NextInner<T>
    extends Operators.MonoSubscriber<T, T> {
        final MonoProcessor<T> parent;

        NextInner(CoreSubscriber<? super T> actual, MonoProcessor<T> parent) {
            super(actual);
            this.parent = parent;
        }

        @Override
        public void cancel() {
            if (STATE.getAndSet(this, 4) != 4) {
                this.parent.remove(this);
            }
        }

        @Override
        public void onComplete() {
            if (!this.isCancelled()) {
                this.actual.onComplete();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.isCancelled()) {
                Operators.onOperatorError(t, this.currentContext());
            } else {
                this.actual.onError(t);
            }
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            return super.scanUnsafe(key);
        }
    }
}

