/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Logger;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Futures;

public class RoutingTableHandler
implements RoutingErrorHandler {
    private final RoutingTable routingTable;
    private final String databaseName;
    private final RoutingTableRegistry routingTableRegistry;
    private volatile CompletableFuture<RoutingTable> refreshRoutingTableFuture;
    private final ConnectionPool connectionPool;
    private final Rediscovery rediscovery;
    private final Logger log;
    private final long routingTablePurgeDelayMs;

    public RoutingTableHandler(RoutingTable routingTable, Rediscovery rediscovery, ConnectionPool connectionPool, RoutingTableRegistry routingTableRegistry, Logger log, long routingTablePurgeDelayMs) {
        this.routingTable = routingTable;
        this.databaseName = routingTable.database();
        this.rediscovery = rediscovery;
        this.connectionPool = connectionPool;
        this.routingTableRegistry = routingTableRegistry;
        this.log = log;
        this.routingTablePurgeDelayMs = routingTablePurgeDelayMs;
    }

    @Override
    public void onConnectionFailure(BoltServerAddress address) {
        this.routingTable.forget(address);
    }

    @Override
    public void onWriteFailure(BoltServerAddress address) {
        this.routingTable.forgetWriter(address);
    }

    synchronized CompletionStage<RoutingTable> refreshRoutingTable(ConnectionContext context) {
        if (this.refreshRoutingTableFuture != null) {
            return this.refreshRoutingTableFuture;
        }
        if (this.routingTable.isStaleFor(context.mode())) {
            this.log.info("Routing table for database '%s' is stale. %s", this.databaseName, this.routingTable);
            CompletableFuture<RoutingTable> resultFuture = new CompletableFuture<RoutingTable>();
            this.refreshRoutingTableFuture = resultFuture;
            this.rediscovery.lookupClusterComposition(this.routingTable, this.connectionPool, context.rediscoveryBookmark()).whenComplete((composition, completionError) -> {
                Throwable error = Futures.completionExceptionCause(completionError);
                if (error != null) {
                    this.clusterCompositionLookupFailed(error);
                } else {
                    this.freshClusterCompositionFetched((ClusterComposition)composition);
                }
            });
            return resultFuture;
        }
        return CompletableFuture.completedFuture(this.routingTable);
    }

    private synchronized void freshClusterCompositionFetched(ClusterComposition composition) {
        try {
            this.routingTable.update(composition);
            this.routingTableRegistry.purgeAged();
            this.connectionPool.retainAll(this.routingTableRegistry.allServers());
            this.log.info("Updated routing table for database '%s'. %s", this.databaseName, this.routingTable);
            CompletableFuture<RoutingTable> routingTableFuture = this.refreshRoutingTableFuture;
            this.refreshRoutingTableFuture = null;
            routingTableFuture.complete(this.routingTable);
        }
        catch (Throwable error) {
            this.clusterCompositionLookupFailed(error);
        }
    }

    private synchronized void clusterCompositionLookupFailed(Throwable error) {
        this.log.error(String.format("Failed to update routing table for database '%s'. Current routing table: %s.", this.databaseName, this.routingTable), error);
        this.routingTableRegistry.remove(this.databaseName);
        CompletableFuture<RoutingTable> routingTableFuture = this.refreshRoutingTableFuture;
        this.refreshRoutingTableFuture = null;
        routingTableFuture.completeExceptionally(error);
    }

    public Set<BoltServerAddress> servers() {
        return this.routingTable.servers();
    }

    public boolean isRoutingTableAged() {
        return this.refreshRoutingTableFuture == null && this.routingTable.hasBeenStaleFor(this.routingTablePurgeDelayMs);
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }
}

