/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.neo4j.driver.Record;
import org.neo4j.driver.internal.cursor.RxStatementResultCursor;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxStatementResult;
import org.neo4j.driver.summary.ResultSummary;
import org.reactivestreams.Publisher;

public class InternalRxStatementResult
implements RxStatementResult {
    private Supplier<CompletionStage<RxStatementResultCursor>> cursorFutureSupplier;
    private volatile CompletionStage<RxStatementResultCursor> cursorFuture;

    public InternalRxStatementResult(Supplier<CompletionStage<RxStatementResultCursor>> cursorFuture) {
        this.cursorFutureSupplier = cursorFuture;
    }

    @Override
    public Publisher<String> keys() {
        return Flux.defer(() -> Mono.fromCompletionStage(this.getCursorFuture()).flatMapIterable(RxStatementResultCursor::keys).onErrorMap(Futures::completionExceptionCause));
    }

    @Override
    public Publisher<Record> records() {
        return Flux.create(sink -> this.getCursorFuture().whenComplete((cursor, completionError) -> {
            if (cursor != null) {
                if (cursor.isDone()) {
                    sink.complete();
                } else {
                    cursor.installRecordConsumer((r, e) -> {
                        if (r != null) {
                            sink.next(r);
                        } else if (e != null) {
                            sink.error((Throwable)e);
                        } else {
                            sink.complete();
                        }
                    });
                    sink.onCancel(cursor::cancel);
                    sink.onRequest(cursor::request);
                }
            } else {
                Throwable error = Futures.completionExceptionCause(completionError);
                sink.error(error);
            }
        }));
    }

    private CompletionStage<RxStatementResultCursor> getCursorFuture() {
        if (this.cursorFuture != null) {
            return this.cursorFuture;
        }
        return this.initCursorFuture();
    }

    synchronized CompletionStage<RxStatementResultCursor> initCursorFuture() {
        if (this.cursorFuture != null) {
            return this.cursorFuture;
        }
        this.cursorFuture = this.cursorFutureSupplier.get();
        this.cursorFutureSupplier = null;
        return this.cursorFuture;
    }

    @Override
    public Publisher<ResultSummary> summary() {
        return Mono.create(sink -> this.getCursorFuture().whenComplete((cursor, completionError) -> {
            if (cursor != null) {
                cursor.summaryAsync().whenComplete((summary, summaryCompletionError) -> {
                    Throwable error = Futures.completionExceptionCause(summaryCompletionError);
                    if (summary != null) {
                        sink.success(summary);
                    } else {
                        sink.error(error);
                    }
                });
            } else {
                Throwable error = Futures.completionExceptionCause(completionError);
                sink.error(error);
            }
        }));
    }

    Supplier<CompletionStage<RxStatementResultCursor>> cursorFutureSupplier() {
        return this.cursorFutureSupplier;
    }
}

