/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.async.connection.RoutingConnection;
import org.neo4j.driver.internal.cluster.AddressSet;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RediscoveryImpl;
import org.neo4j.driver.internal.cluster.RoutingProcedureClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.cluster.RoutingTableRegistryImpl;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutorGroup;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.net.ServerAddressResolver;

public class LoadBalancer
implements ConnectionProvider {
    private static final String LOAD_BALANCER_LOG_NAME = "LoadBalancer";
    private final ConnectionPool connectionPool;
    private final RoutingTableRegistry routingTables;
    private final LoadBalancingStrategy loadBalancingStrategy;
    private final EventExecutorGroup eventExecutorGroup;
    private final Logger log;

    public LoadBalancer(BoltServerAddress initialRouter, RoutingSettings settings, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, Clock clock, Logging logging, LoadBalancingStrategy loadBalancingStrategy, ServerAddressResolver resolver) {
        this(connectionPool, LoadBalancer.createRoutingTables(connectionPool, eventExecutorGroup, initialRouter, resolver, settings, clock, logging), LoadBalancer.loadBalancerLogger(logging), loadBalancingStrategy, eventExecutorGroup);
    }

    LoadBalancer(ConnectionPool connectionPool, RoutingTableRegistry routingTables, Logger log, LoadBalancingStrategy loadBalancingStrategy, EventExecutorGroup eventExecutorGroup) {
        this.connectionPool = connectionPool;
        this.routingTables = routingTables;
        this.loadBalancingStrategy = loadBalancingStrategy;
        this.eventExecutorGroup = eventExecutorGroup;
        this.log = log;
    }

    @Override
    public CompletionStage<Connection> acquireConnection(String databaseName, AccessMode mode) {
        return this.routingTables.refreshRoutingTable(databaseName, mode).thenCompose(handler -> this.acquire(mode, handler.routingTable()).thenApply(connection -> new RoutingConnection((Connection)connection, databaseName, mode, (RoutingErrorHandler)handler)));
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.routingTables.refreshRoutingTable("", AccessMode.READ).handle((ignored, error) -> {
            if (error != null) {
                Throwable cause = Futures.completionExceptionCause(error);
                if (cause instanceof ServiceUnavailableException) {
                    throw Futures.asCompletionException(new ServiceUnavailableException("Unable to connect to database, ensure the database is running and that there is a working network connection to it.", cause));
                }
                throw Futures.asCompletionException(cause);
            }
            return null;
        });
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionPool.close();
    }

    private CompletionStage<Connection> acquire(AccessMode mode, RoutingTable routingTable) {
        AddressSet addresses = LoadBalancer.addressSet(mode, routingTable);
        CompletableFuture<Connection> result = new CompletableFuture<Connection>();
        this.acquire(mode, routingTable, addresses, result);
        return result;
    }

    private void acquire(AccessMode mode, RoutingTable routingTable, AddressSet addresses, CompletableFuture<Connection> result) {
        BoltServerAddress address = this.selectAddress(mode, addresses);
        if (address == null) {
            result.completeExceptionally(new SessionExpiredException("Failed to obtain connection towards " + (Object)((Object)mode) + " server. Known routing table is: " + routingTable));
            return;
        }
        this.connectionPool.acquire(address).whenComplete((connection, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                if (error instanceof ServiceUnavailableException) {
                    SessionExpiredException errorToLog = new SessionExpiredException(String.format("Server at %s is no longer available", address), error);
                    this.log.warn("Failed to obtain a connection towards address " + address, errorToLog);
                    routingTable.forget(address);
                    this.eventExecutorGroup.next().execute(() -> this.acquire(mode, routingTable, addresses, result));
                } else {
                    result.completeExceptionally(error);
                }
            } else {
                result.complete((Connection)connection);
            }
        });
    }

    private static AddressSet addressSet(AccessMode mode, RoutingTable routingTable) {
        switch (mode) {
            case READ: {
                return routingTable.readers();
            }
            case WRITE: {
                return routingTable.writers();
            }
        }
        throw LoadBalancer.unknownMode(mode);
    }

    private BoltServerAddress selectAddress(AccessMode mode, AddressSet servers) {
        BoltServerAddress[] addresses = servers.toArray();
        switch (mode) {
            case READ: {
                return this.loadBalancingStrategy.selectReader(addresses);
            }
            case WRITE: {
                return this.loadBalancingStrategy.selectWriter(addresses);
            }
        }
        throw LoadBalancer.unknownMode(mode);
    }

    private static RoutingTableRegistry createRoutingTables(ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, BoltServerAddress initialRouter, ServerAddressResolver resolver, RoutingSettings settings, Clock clock, Logging logging) {
        Logger log = LoadBalancer.loadBalancerLogger(logging);
        Rediscovery rediscovery = LoadBalancer.createRediscovery(eventExecutorGroup, initialRouter, resolver, settings, clock, log);
        return new RoutingTableRegistryImpl(connectionPool, rediscovery, clock, log);
    }

    private static Rediscovery createRediscovery(EventExecutorGroup eventExecutorGroup, BoltServerAddress initialRouter, ServerAddressResolver resolver, RoutingSettings settings, Clock clock, Logger log) {
        RoutingProcedureClusterCompositionProvider clusterCompositionProvider = new RoutingProcedureClusterCompositionProvider(clock, settings);
        return new RediscoveryImpl(initialRouter, settings, clusterCompositionProvider, eventExecutorGroup, resolver, log);
    }

    private static Logger loadBalancerLogger(Logging logging) {
        return logging.getLog(LOAD_BALANCER_LOG_NAME);
    }

    private static RuntimeException unknownMode(AccessMode mode) {
        return new IllegalArgumentException("Mode '" + (Object)((Object)mode) + "' is not supported");
    }
}

