/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Record;
import org.neo4j.driver.Statement;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.StatementResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ServerVersion;

public class RoutingProcedureRunner {
    static final String ROUTING_CONTEXT = "context";
    static final String GET_ROUTING_TABLE = "dbms.cluster.routing.getRoutingTable($context)";
    static final String DATABASE_NAME = "database";
    static final String MULTI_DB_GET_ROUTING_TABLE = String.format("dbms.routing.getRoutingTable($%s, $%s)", "context", "database");
    private final RoutingContext context;

    public RoutingProcedureRunner(RoutingContext context) {
        this.context = context;
    }

    public CompletionStage<RoutingProcedureResponse> run(CompletionStage<Connection> connectionStage, String databaseName) {
        return connectionStage.thenCompose(connection -> {
            ServerVersion serverVersion = connection.serverVersion();
            DirectConnection delegate = this.connection(serverVersion, (Connection)connection);
            Statement procedure = this.procedureStatement(serverVersion, databaseName);
            return this.runProcedure(delegate, procedure).thenCompose(records -> this.releaseConnection(delegate, (List<Record>)records)).handle((records, error) -> this.processProcedureResponse(procedure, (List<Record>)records, (Throwable)error));
        });
    }

    CompletionStage<List<Record>> runProcedure(Connection connection, Statement procedure) {
        return connection.protocol().runInAutoCommitTransaction(connection, procedure, BookmarksHolder.NO_OP, TransactionConfig.empty(), true).asyncResult().thenCompose(StatementResultCursor::listAsync);
    }

    private DirectConnection connection(ServerVersion serverVersion, Connection connection) {
        if (serverVersion.greaterThanOrEqual(ServerVersion.v4_0_0)) {
            return new DirectConnection(connection, "system", AccessMode.READ);
        }
        return new DirectConnection(connection, "", AccessMode.WRITE);
    }

    private Statement procedureStatement(ServerVersion serverVersion, String databaseName) {
        if (Objects.equals("", databaseName)) {
            databaseName = null;
        }
        if (serverVersion.greaterThanOrEqual(ServerVersion.v4_0_0)) {
            return new Statement("CALL " + MULTI_DB_GET_ROUTING_TABLE, Values.parameters(ROUTING_CONTEXT, this.context.asMap(), DATABASE_NAME, databaseName));
        }
        if (databaseName != null) {
            throw new FatalDiscoveryException(String.format("Refreshing routing table for multi-databases is not supported in server version lower than 4.0. Current server version: %s. Database name: `%s`", serverVersion, databaseName));
        }
        return new Statement("CALL dbms.cluster.routing.getRoutingTable($context)", Values.parameters(ROUTING_CONTEXT, this.context.asMap()));
    }

    private CompletionStage<List<Record>> releaseConnection(Connection connection, List<Record> records) {
        return connection.release().thenApply(ignore -> records);
    }

    private RoutingProcedureResponse processProcedureResponse(Statement procedure, List<Record> records, Throwable error) {
        Throwable cause = Futures.completionExceptionCause(error);
        if (cause != null) {
            return this.handleError(procedure, cause);
        }
        return new RoutingProcedureResponse(procedure, records);
    }

    private RoutingProcedureResponse handleError(Statement procedure, Throwable error) {
        if (error instanceof ClientException) {
            return new RoutingProcedureResponse(procedure, error);
        }
        throw new CompletionException(error);
    }
}

