/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.SessionParametersTemplate;

public class SessionParameters {
    private static final SessionParameters EMPTY = SessionParameters.template().build();
    private final List<String> bookmarks;
    private final AccessMode defaultAccessMode;
    private final String database;

    public static Template template() {
        return new Template();
    }

    public static SessionParameters empty() {
        return EMPTY;
    }

    private SessionParameters(Template template) {
        this.bookmarks = template.bookmarks;
        this.defaultAccessMode = template.defaultAccessMode;
        this.database = template.database;
    }

    public List<String> bookmarks() {
        return this.bookmarks;
    }

    public AccessMode defaultAccessMode() {
        return this.defaultAccessMode;
    }

    public Optional<String> database() {
        return Optional.ofNullable(this.database);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionParameters that = (SessionParameters)o;
        return Objects.equals(this.bookmarks, that.bookmarks) && this.defaultAccessMode == that.defaultAccessMode && this.database.equals(that.database);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bookmarks, this.defaultAccessMode, this.database});
    }

    public String toString() {
        return "SessionParameters{bookmarks=" + this.bookmarks + ", defaultAccessMode=" + (Object)((Object)this.defaultAccessMode) + ", database='" + this.database + '\'' + '}';
    }

    public static class Template
    implements SessionParametersTemplate {
        private List<String> bookmarks = null;
        private AccessMode defaultAccessMode = AccessMode.WRITE;
        private String database = null;

        private Template() {
        }

        @Override
        public Template withBookmarks(String ... bookmarks) {
            this.bookmarks = bookmarks == null ? null : Arrays.asList(bookmarks);
            return this;
        }

        @Override
        public Template withBookmarks(List<String> bookmarks) {
            this.bookmarks = bookmarks;
            return this;
        }

        @Override
        public Template withDefaultAccessMode(AccessMode mode) {
            this.defaultAccessMode = mode;
            return this;
        }

        @Override
        public Template withDatabase(String database) {
            if ("".equals(database)) {
                throw new IllegalArgumentException(String.format("Illegal database name '%s'.", database));
            }
            this.database = database;
            return this;
        }

        SessionParameters build() {
            return new SessionParameters(this);
        }
    }
}

