/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v4;

import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Statement;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.handlers.AbstractPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullHandlers;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.MessageFormatV4;
import org.neo4j.driver.internal.reactive.cursor.InternalStatementResultCursorFactory;
import org.neo4j.driver.internal.reactive.cursor.StatementResultCursorFactory;
import org.neo4j.driver.internal.spi.Connection;

public class BoltProtocolV4
extends BoltProtocolV3 {
    public static final int VERSION = 4;
    public static final BoltProtocol INSTANCE = new BoltProtocolV4();

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV4();
    }

    @Override
    protected StatementResultCursorFactory buildResultCursorFactory(Connection connection, Statement statement, BookmarksHolder bookmarksHolder, ExplicitTransaction tx, RunWithMetadataMessage runMessage, boolean waitForRunResponse) {
        CompletableFuture<Throwable> runCompletedFuture = new CompletableFuture<Throwable>();
        RunResponseHandler runHandler = new RunResponseHandler(runCompletedFuture, METADATA_EXTRACTOR);
        AbstractPullAllResponseHandler pullAllHandler = PullHandlers.newBoltV3PullAllHandler(statement, runHandler, connection, bookmarksHolder, tx);
        BasicPullResponseHandler pullHandler = PullHandlers.newBoltV4PullHandler(statement, runHandler, connection, bookmarksHolder, tx);
        return new InternalStatementResultCursorFactory(connection, runMessage, runHandler, pullHandler, pullAllHandler, waitForRunResponse);
    }

    @Override
    protected void verifyDatabaseNameBeforeTransaction(String databaseName) {
    }

    @Override
    public int version() {
        return 4;
    }
}

