/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Record;
import org.neo4j.driver.Statement;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.StatementResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.async.DecoratedConnection;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ServerVersion;

public class RoutingProcedureRunner {
    static final String GET_SERVERS = "dbms.cluster.routing.getServers";
    static final String GET_ROUTING_TABLE_PARAM = "context";
    static final String GET_ROUTING_TABLE = "dbms.cluster.routing.getRoutingTable({context})";
    private final RoutingContext context;

    public RoutingProcedureRunner(RoutingContext context) {
        this.context = context;
    }

    public CompletionStage<RoutingProcedureResponse> run(CompletionStage<Connection> connectionStage) {
        return connectionStage.thenCompose(connection -> {
            DecoratedConnection delegate = new DecoratedConnection((Connection)connection, "", AccessMode.WRITE);
            Statement procedure = this.procedureStatement(delegate.serverVersion());
            return this.runProcedure(delegate, procedure).thenCompose(records -> this.releaseConnection(delegate, (List<Record>)records)).handle((records, error) -> this.processProcedureResponse(procedure, (List<Record>)records, (Throwable)error));
        });
    }

    CompletionStage<List<Record>> runProcedure(Connection connection, Statement procedure) {
        return connection.protocol().runInAutoCommitTransaction(connection, procedure, BookmarksHolder.NO_OP, TransactionConfig.empty(), true).asyncResult().thenCompose(StatementResultCursor::listAsync);
    }

    private Statement procedureStatement(ServerVersion serverVersion) {
        if (serverVersion.greaterThanOrEqual(ServerVersion.v3_2_0)) {
            return new Statement("CALL dbms.cluster.routing.getRoutingTable({context})", Values.parameters(GET_ROUTING_TABLE_PARAM, this.context.asMap()));
        }
        return new Statement("CALL dbms.cluster.routing.getServers");
    }

    private CompletionStage<List<Record>> releaseConnection(Connection connection, List<Record> records) {
        return connection.release().thenApply(ignore -> records);
    }

    private RoutingProcedureResponse processProcedureResponse(Statement procedure, List<Record> records, Throwable error) {
        Throwable cause = Futures.completionExceptionCause(error);
        if (cause != null) {
            return this.handleError(procedure, cause);
        }
        return new RoutingProcedureResponse(procedure, records);
    }

    private RoutingProcedureResponse handleError(Statement procedure, Throwable error) {
        if (error instanceof ClientException) {
            return new RoutingProcedureResponse(procedure, error);
        }
        throw new CompletionException(error);
    }
}

