/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Config;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.DefaultBookmarksHolder;
import org.neo4j.driver.internal.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionParameters;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;

public class SessionFactoryImpl
implements SessionFactory {
    private final ConnectionProvider connectionProvider;
    private final RetryLogic retryLogic;
    private final Logging logging;
    private final boolean leakedSessionsLoggingEnabled;

    SessionFactoryImpl(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        this.connectionProvider = connectionProvider;
        this.leakedSessionsLoggingEnabled = config.logLeakedSessions();
        this.retryLogic = retryLogic;
        this.logging = config.logging();
    }

    @Override
    public NetworkSession newInstance(SessionParameters parameters) {
        DefaultBookmarksHolder bookmarksHolder = new DefaultBookmarksHolder(Bookmarks.from(parameters.bookmarks()));
        return this.createSession(this.connectionProvider, this.retryLogic, parameters.database(), parameters.defaultAccessMode(), bookmarksHolder, this.logging);
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.connectionProvider.verifyConnectivity();
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionProvider.close();
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    private NetworkSession createSession(ConnectionProvider connectionProvider, RetryLogic retryLogic, String databaseName, AccessMode mode, BookmarksHolder bookmarksHolder, Logging logging) {
        return this.leakedSessionsLoggingEnabled ? new LeakLoggingNetworkSession(connectionProvider, retryLogic, databaseName, mode, bookmarksHolder, logging) : new NetworkSession(connectionProvider, retryLogic, databaseName, mode, bookmarksHolder, logging);
    }
}

