/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelConnector;
import org.neo4j.driver.internal.async.DirectConnection;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.async.pool.NettyChannelHealthChecker;
import org.neo4j.driver.internal.async.pool.NettyChannelPool;
import org.neo4j.driver.internal.async.pool.NettyChannelTracker;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPool;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class ConnectionPoolImpl
implements ConnectionPool {
    private final ChannelConnector connector;
    private final Bootstrap bootstrap;
    private final NettyChannelTracker nettyChannelTracker;
    private final NettyChannelHealthChecker channelHealthChecker;
    private final PoolSettings settings;
    private final Clock clock;
    private final Logger log;
    private final MetricsListener metricsListener;
    private final ConcurrentMap<BoltServerAddress, ExtendedChannelPool> pools = new ConcurrentHashMap<BoltServerAddress, ExtendedChannelPool>();
    private final AtomicBoolean closed = new AtomicBoolean();

    public ConnectionPoolImpl(ChannelConnector connector, Bootstrap bootstrap, PoolSettings settings, MetricsListener metricsListener, Logging logging, Clock clock) {
        this(connector, bootstrap, new NettyChannelTracker(metricsListener, bootstrap.config().group().next(), logging), settings, metricsListener, logging, clock);
    }

    ConnectionPoolImpl(ChannelConnector connector, Bootstrap bootstrap, NettyChannelTracker nettyChannelTracker, PoolSettings settings, MetricsListener metricsListener, Logging logging, Clock clock) {
        this.connector = connector;
        this.bootstrap = bootstrap;
        this.nettyChannelTracker = nettyChannelTracker;
        this.channelHealthChecker = new NettyChannelHealthChecker(settings, clock, logging);
        this.settings = settings;
        this.metricsListener = metricsListener;
        this.clock = clock;
        this.log = logging.getLog(ConnectionPool.class.getSimpleName());
    }

    @Override
    public CompletionStage<Connection> acquire(BoltServerAddress address) {
        this.log.trace("Acquiring a connection from pool towards %s", address);
        this.assertNotClosed();
        ExtendedChannelPool pool = this.getOrCreatePool(address);
        ListenerEvent acquireEvent = this.metricsListener.createListenerEvent();
        this.metricsListener.beforeAcquiringOrCreating(address, acquireEvent);
        Future<Channel> connectionFuture = pool.acquire();
        return Futures.asCompletionStage(connectionFuture).handle((channel, error) -> {
            try {
                this.processAcquisitionError(pool, address, (Throwable)error);
                this.assertNotClosed(address, (Channel)channel, pool);
                DirectConnection connection = new DirectConnection((Channel)channel, pool, this.clock, this.metricsListener);
                this.metricsListener.afterAcquiredOrCreated(address, acquireEvent);
                DirectConnection directConnection = connection;
                return directConnection;
            }
            finally {
                this.metricsListener.afterAcquiringOrCreating(address);
            }
        });
    }

    @Override
    public void retainAll(Set<BoltServerAddress> addressesToRetain) {
        for (BoltServerAddress address : this.pools.keySet()) {
            ChannelPool pool;
            int activeChannels;
            if (addressesToRetain.contains(address) || (activeChannels = this.nettyChannelTracker.inUseChannelCount(address)) != 0 || (pool = (ChannelPool)this.pools.remove(address)) == null) continue;
            this.log.info("Closing connection pool towards %s, it has no active connections and is not in the routing table", address);
            pool.close();
        }
    }

    @Override
    public int inUseConnections(BoltServerAddress address) {
        return this.nettyChannelTracker.inUseChannelCount(address);
    }

    @Override
    public int idleConnections(BoltServerAddress address) {
        return this.nettyChannelTracker.idleChannelCount(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.nettyChannelTracker.prepareToCloseChannels();
                for (Map.Entry entry : this.pools.entrySet()) {
                    BoltServerAddress address = (BoltServerAddress)entry.getKey();
                    ChannelPool pool = (ChannelPool)entry.getValue();
                    this.log.info("Closing connection pool towards %s", address);
                    pool.close();
                }
                this.pools.clear();
            }
            finally {
                this.eventLoopGroup().shutdownGracefully();
            }
        }
        return Futures.asCompletionStage(this.eventLoopGroup().terminationFuture()).thenApply(ignore -> null);
    }

    @Override
    public boolean isOpen(BoltServerAddress address) {
        return this.pools.containsKey(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedChannelPool getOrCreatePool(BoltServerAddress address) {
        ExtendedChannelPool pool = (ExtendedChannelPool)this.pools.get(address);
        if (pool != null) {
            return pool;
        }
        ConnectionPoolImpl connectionPoolImpl = this;
        synchronized (connectionPoolImpl) {
            pool = (ExtendedChannelPool)this.pools.get(address);
            if (pool != null) {
                return pool;
            }
            this.metricsListener.addMetrics(address, this);
            pool = this.newPool(address);
            this.pools.put(address, pool);
        }
        return pool;
    }

    ExtendedChannelPool newPool(BoltServerAddress address) {
        return new NettyChannelPool(address, this.connector, this.bootstrap, this.nettyChannelTracker, this.channelHealthChecker, this.settings.connectionAcquisitionTimeout(), this.settings.maxConnectionPoolSize());
    }

    private EventLoopGroup eventLoopGroup() {
        return this.bootstrap.config().group();
    }

    private void processAcquisitionError(ExtendedChannelPool pool, BoltServerAddress serverAddress, Throwable error) {
        Throwable cause = Futures.completionExceptionCause(error);
        if (cause != null) {
            if (cause instanceof TimeoutException) {
                this.metricsListener.afterTimedOutToAcquireOrCreate(serverAddress);
                throw new ClientException("Unable to acquire connection from the pool within configured maximum time of " + this.settings.connectionAcquisitionTimeout() + "ms");
            }
            if (pool.isClosed()) {
                throw new ServiceUnavailableException(String.format("Connection pool for server %s is closed while acquiring a connection.", serverAddress), cause);
            }
            throw new CompletionException(cause);
        }
    }

    private void assertNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Pool closed");
        }
    }

    private void assertNotClosed(BoltServerAddress address, Channel channel, ChannelPool pool) {
        if (this.closed.get()) {
            pool.release(channel);
            pool.close();
            this.pools.remove(address);
            this.assertNotClosed();
        }
    }

    public String toString() {
        return "ConnectionPoolImpl{pools=" + this.pools + '}';
    }

    ExtendedChannelPool getPool(BoltServerAddress address) {
        return (ExtendedChannelPool)this.pools.get(address);
    }
}

