/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.neo4j.driver.internal.handlers.ResetResponseHandler;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.messaging.ResponseMessageHandler;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class InboundMessageDispatcher
implements ResponseMessageHandler {
    private final Channel channel;
    private final Queue<ResponseHandler> handlers = new LinkedList<ResponseHandler>();
    private final Logger log;
    private Throwable currentError;
    private boolean fatalErrorOccurred;
    private ResponseHandler autoReadManagingHandler;

    public InboundMessageDispatcher(Channel channel, Logging logging) {
        this.channel = Objects.requireNonNull(channel);
        this.log = new ChannelActivityLogger(channel, logging, this.getClass());
    }

    public void enqueue(ResponseHandler handler) {
        if (this.fatalErrorOccurred) {
            handler.onFailure(this.currentError);
        } else {
            this.handlers.add(handler);
            this.updateAutoReadManagingHandlerIfNeeded(handler);
        }
    }

    public int queuedHandlersCount() {
        return this.handlers.size();
    }

    @Override
    public void handleSuccessMessage(Map<String, Value> meta) {
        this.log.debug("S: SUCCESS %s", meta);
        ResponseHandler handler = this.removeHandler();
        handler.onSuccess(meta);
    }

    @Override
    public void handleRecordMessage(Value[] fields) {
        ResponseHandler handler;
        if (this.log.isDebugEnabled()) {
            this.log.debug("S: RECORD %s", Arrays.toString(fields));
        }
        if ((handler = this.handlers.peek()) == null) {
            throw new IllegalStateException("No handler exists to handle RECORD message with fields: " + Arrays.toString(fields));
        }
        handler.onRecord(fields);
    }

    @Override
    public void handleFailureMessage(String code, String message) {
        this.log.debug("S: FAILURE %s \"%s\"", code, message);
        this.currentError = ErrorUtil.newNeo4jError(code, message);
        if (ErrorUtil.isFatal(this.currentError)) {
            this.channel.pipeline().fireExceptionCaught(this.currentError);
            return;
        }
        this.enqueue(new ResetResponseHandler(this));
        this.channel.writeAndFlush(ResetMessage.RESET, this.channel.voidPromise());
        ResponseHandler handler = this.removeHandler();
        handler.onFailure(this.currentError);
    }

    @Override
    public void handleIgnoredMessage() {
        Throwable error;
        this.log.debug("S: IGNORED", new Object[0]);
        ResponseHandler handler = this.removeHandler();
        if (this.currentError != null) {
            error = this.currentError;
        } else {
            this.log.warn("Received IGNORED message for handler %s but error is missing and RESET is not in progress. Current handlers %s", handler, this.handlers);
            error = new ClientException("Database ignored the request");
        }
        handler.onFailure(error);
    }

    public void handleFatalError(Throwable error) {
        this.currentError = error;
        this.fatalErrorOccurred = true;
        while (!this.handlers.isEmpty()) {
            ResponseHandler handler = this.removeHandler();
            handler.onFailure(this.currentError);
        }
    }

    public void clearCurrentError() {
        this.currentError = null;
    }

    public Throwable currentError() {
        return this.currentError;
    }

    public boolean fatalErrorOccurred() {
        return this.fatalErrorOccurred;
    }

    ResponseHandler autoReadManagingHandler() {
        return this.autoReadManagingHandler;
    }

    private ResponseHandler removeHandler() {
        ResponseHandler handler = this.handlers.remove();
        if (handler == this.autoReadManagingHandler) {
            this.updateAutoReadManagingHandler(null);
        }
        return handler;
    }

    private void updateAutoReadManagingHandlerIfNeeded(ResponseHandler handler) {
        if (handler.canManageAutoRead()) {
            this.updateAutoReadManagingHandler(handler);
        }
    }

    private void updateAutoReadManagingHandler(ResponseHandler newHandler) {
        if (this.autoReadManagingHandler != null) {
            this.autoReadManagingHandler.disableAutoReadManagement();
            this.channel.config().setAutoRead(true);
        }
        this.autoReadManagingHandler = newHandler;
    }
}

