/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Objects;
import org.neo4j.driver.v1.net.ServerAddress;

public class BoltServerAddress
implements ServerAddress {
    public static final int DEFAULT_PORT = 7687;
    public static final BoltServerAddress LOCAL_DEFAULT = new BoltServerAddress("localhost", 7687);
    private final String originalHost;
    private final String host;
    private final int port;
    private final String stringValue;

    public BoltServerAddress(String address) {
        this(BoltServerAddress.uriFrom(address));
    }

    public BoltServerAddress(URI uri) {
        this(BoltServerAddress.hostFrom(uri), BoltServerAddress.portFrom(uri));
    }

    public BoltServerAddress(String host, int port) {
        this(host, host, port);
    }

    public BoltServerAddress(String originalHost, String host, int port) {
        this.originalHost = Objects.requireNonNull(originalHost, "original host");
        this.host = Objects.requireNonNull(host, "host");
        this.port = BoltServerAddress.requireValidPort(port);
        this.stringValue = String.format("%s:%d", host, port);
    }

    public static BoltServerAddress from(ServerAddress address) {
        return address instanceof BoltServerAddress ? (BoltServerAddress)address : new BoltServerAddress(address.host(), address.port());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoltServerAddress that = (BoltServerAddress)o;
        return this.port == that.port && this.originalHost.equals(that.originalHost) && this.host.equals(that.host);
    }

    public int hashCode() {
        return Objects.hash(this.originalHost, this.host, this.port);
    }

    public String toString() {
        return this.stringValue;
    }

    public SocketAddress toSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public BoltServerAddress resolve() throws UnknownHostException {
        String ipAddress = InetAddress.getByName(this.host).getHostAddress();
        if (ipAddress.equals(this.host)) {
            return this;
        }
        return new BoltServerAddress(this.host, ipAddress, this.port);
    }

    @Override
    public String host() {
        return this.host;
    }

    public String originalHost() {
        return this.originalHost;
    }

    @Override
    public int port() {
        return this.port;
    }

    private static String hostFrom(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            throw BoltServerAddress.invalidAddressFormat(uri);
        }
        return host;
    }

    private static int portFrom(URI uri) {
        int port = uri.getPort();
        return port == -1 ? 7687 : port;
    }

    private static URI uriFrom(String address) {
        String hostPort;
        String scheme;
        String[] schemeSplit = address.split("://");
        if (schemeSplit.length == 1) {
            scheme = "bolt://";
            hostPort = BoltServerAddress.hostPortFrom(schemeSplit[0]);
        } else if (schemeSplit.length == 2) {
            scheme = schemeSplit[0] + "://";
            hostPort = BoltServerAddress.hostPortFrom(schemeSplit[1]);
        } else {
            throw BoltServerAddress.invalidAddressFormat(address);
        }
        return URI.create(scheme + hostPort);
    }

    private static String hostPortFrom(String address) {
        boolean containsSingleColon;
        if (address.startsWith("[")) {
            return address;
        }
        boolean bl = containsSingleColon = address.indexOf(":") == address.lastIndexOf(":");
        if (containsSingleColon) {
            return address;
        }
        return "[" + address + "]";
    }

    private static RuntimeException invalidAddressFormat(URI uri) {
        return BoltServerAddress.invalidAddressFormat(uri.toString());
    }

    private static RuntimeException invalidAddressFormat(String address) {
        return new IllegalArgumentException("Invalid address format `" + address + "`");
    }

    private static int requireValidPort(int port) {
        if (port >= 0 && port <= 65535) {
            return port;
        }
        throw new IllegalArgumentException("Illegal port: " + port);
    }
}

