/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.InternalStatementResultCursor;
import org.neo4j.driver.internal.util.Futures;

public class ResultCursorsHolder {
    private final List<CompletionStage<InternalStatementResultCursor>> cursorStages = new ArrayList<CompletionStage<InternalStatementResultCursor>>();

    public void add(CompletionStage<InternalStatementResultCursor> cursorStage) {
        Objects.requireNonNull(cursorStage);
        this.cursorStages.add(cursorStage);
    }

    public CompletionStage<Throwable> retrieveNotConsumedError() {
        CompletableFuture[] failures = this.retrieveAllFailures();
        return CompletableFuture.allOf(failures).thenApply(ignore -> ResultCursorsHolder.findFirstFailure(failures));
    }

    private CompletableFuture<Throwable>[] retrieveAllFailures() {
        return (CompletableFuture[])this.cursorStages.stream().map(ResultCursorsHolder::retrieveFailure).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new);
    }

    private static Throwable findFirstFailure(CompletableFuture<Throwable>[] completedFailureFutures) {
        for (CompletableFuture<Throwable> failureFuture : completedFailureFutures) {
            Throwable failure = failureFuture.getNow(null);
            if (failure == null) continue;
            return failure;
        }
        return null;
    }

    private static CompletionStage<Throwable> retrieveFailure(CompletionStage<InternalStatementResultCursor> cursorStage) {
        return cursorStage.exceptionally(cursor -> null).thenCompose(cursor -> cursor == null ? Futures.completedWithNull() : cursor.failureAsync());
    }
}

