/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.neo4j.driver.internal.logging.JULogger;
import org.neo4j.driver.v1.Logging;

public class ConsoleLogging
implements Logging {
    private final Level level;

    public ConsoleLogging(Level level) {
        this.level = Objects.requireNonNull(level);
    }

    @Override
    public org.neo4j.driver.v1.Logger getLog(String name) {
        return new ConsoleLogger(name, this.level);
    }

    private static class ShortFormatter
    extends Formatter {
        private ShortFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + " " + record.getLevel() + " " + record.getLoggerName() + " - " + this.formatMessage(record) + "\n";
        }
    }

    static class ConsoleLogger
    extends JULogger {
        private final ConsoleHandler handler;

        ConsoleLogger(String name, Level level) {
            super(name, level);
            Handler[] handlers;
            Logger logger = Logger.getLogger(name);
            logger.setUseParentHandlers(false);
            for (Handler handlerToRemove : handlers = logger.getHandlers()) {
                logger.removeHandler(handlerToRemove);
            }
            this.handler = new ConsoleHandler();
            this.handler.setFormatter(new ShortFormatter());
            this.handler.setLevel(level);
            logger.addHandler(this.handler);
            logger.setLevel(level);
        }
    }
}

