/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.net.URI;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class GraphDatabase {
    private static final String LOGGER_NAME = GraphDatabase.class.getSimpleName();

    public static Driver driver(String uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri, Config config) {
        return GraphDatabase.driver(uri, AuthTokens.none(), config);
    }

    public static Driver driver(String uri, Config config) {
        return GraphDatabase.driver(URI.create(uri), config);
    }

    public static Driver driver(String uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(URI uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(String uri, AuthToken authToken, Config config) {
        return GraphDatabase.driver(URI.create(uri), authToken, config);
    }

    public static Driver driver(URI uri, AuthToken authToken, Config config) {
        config = GraphDatabase.getOrDefault(config);
        RoutingSettings routingSettings = config.routingSettings();
        RetrySettings retrySettings = config.retrySettings();
        return new DriverFactory().newInstance(uri, authToken, routingSettings, retrySettings, config);
    }

    public static Driver routingDriver(Iterable<URI> routingUris, AuthToken authToken, Config config) {
        GraphDatabase.assertRoutingUris(routingUris);
        Logger log = GraphDatabase.createLogger(config);
        for (URI uri : routingUris) {
            try {
                return GraphDatabase.driver(uri, authToken, config);
            }
            catch (ServiceUnavailableException e) {
                log.warn("Unable to create routing driver for URI: " + uri, e);
            }
        }
        throw new ServiceUnavailableException("Failed to discover an available server");
    }

    private static void assertRoutingUris(Iterable<URI> uris) {
        for (URI uri : uris) {
            if ("bolt+routing".equals(uri.getScheme())) continue;
            throw new IllegalArgumentException("Illegal URI scheme, expected 'bolt+routing' in '" + uri + "'");
        }
    }

    private static Logger createLogger(Config config) {
        Logging logging = GraphDatabase.getOrDefault(config).logging();
        return logging.getLog(LOGGER_NAME);
    }

    private static Config getOrDefault(Config config) {
        return config != null ? config : Config.defaultConfig();
    }
}

