/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.util.Immutable;

@Immutable
public class Statement {
    private final String text;
    private final Value parameters;

    public Statement(String text, Value parameters) {
        this.text = text;
        if (parameters == null) {
            this.parameters = Values.EmptyMap;
        } else if (parameters instanceof MapValue) {
            this.parameters = parameters;
        } else {
            throw new ClientException("The parameters should be provided as Map type. Unsupported parameters type: " + parameters.type().name());
        }
    }

    public Statement(String text, Map<String, Object> parameters) {
        this(text, Values.value(parameters));
    }

    public Statement(String text) {
        this(text, Values.EmptyMap);
    }

    public String text() {
        return this.text;
    }

    public Value parameters() {
        return this.parameters;
    }

    public Statement withText(String newText) {
        return new Statement(newText, this.parameters);
    }

    public Statement withParameters(Value newParameters) {
        return new Statement(this.text, newParameters);
    }

    public Statement withParameters(Map<String, Object> newParameters) {
        return new Statement(this.text, newParameters);
    }

    public Statement withUpdatedParameters(Value updates) {
        if (updates == null || updates.isEmpty()) {
            return this;
        }
        HashMap<String, Value> newParameters = Iterables.newHashMapWithSize(Math.max(this.parameters.size(), updates.size()));
        newParameters.putAll(this.parameters.asMap(Values.ofValue()));
        for (Map.Entry<String, Value> entry : updates.asMap(Values.ofValue()).entrySet()) {
            Value value = entry.getValue();
            if (value.isNull()) {
                newParameters.remove(entry.getKey());
                continue;
            }
            newParameters.put(entry.getKey(), value);
        }
        return this.withParameters(Values.value(newParameters));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statement statement = (Statement)o;
        return this.text.equals(statement.text) && this.parameters.equals(statement.parameters);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        return String.format("Statement{text='%s', parameters=%s}", this.text, this.parameters);
    }
}

