/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;
import org.neo4j.driver.v1.exceptions.TransientException;

public class RoutingResponseHandler
implements ResponseHandler {
    private final ResponseHandler delegate;
    private final BoltServerAddress address;
    private final AccessMode accessMode;
    private final RoutingErrorHandler errorHandler;

    public RoutingResponseHandler(ResponseHandler delegate, BoltServerAddress address, AccessMode accessMode, RoutingErrorHandler errorHandler) {
        this.delegate = delegate;
        this.address = address;
        this.accessMode = accessMode;
        this.errorHandler = errorHandler;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.delegate.onSuccess(metadata);
    }

    @Override
    public void onFailure(Throwable error) {
        Throwable newError = this.handledError(error);
        this.delegate.onFailure(newError);
    }

    @Override
    public void onRecord(Value[] fields) {
        this.delegate.onRecord(fields);
    }

    private Throwable handledError(Throwable receivedError) {
        Throwable error = Futures.completionExceptionCause(receivedError);
        if (error instanceof ServiceUnavailableException) {
            return this.handledServiceUnavailableException((ServiceUnavailableException)error);
        }
        if (error instanceof ClientException) {
            return this.handledClientException((ClientException)error);
        }
        if (error instanceof TransientException) {
            return this.handledTransientException((TransientException)error);
        }
        return error;
    }

    private Throwable handledServiceUnavailableException(ServiceUnavailableException e) {
        this.errorHandler.onConnectionFailure(this.address);
        return new SessionExpiredException(String.format("Server at %s is no longer available", this.address), e);
    }

    private Throwable handledTransientException(TransientException e) {
        String errorCode = e.code();
        if (Objects.equals(errorCode, "Neo.TransientError.General.DatabaseUnavailable")) {
            this.errorHandler.onConnectionFailure(this.address);
        }
        return e;
    }

    private Throwable handledClientException(ClientException e) {
        if (RoutingResponseHandler.isFailureToWrite(e)) {
            switch (this.accessMode) {
                case READ: {
                    return new ClientException("Write queries cannot be performed in READ access mode.");
                }
                case WRITE: {
                    this.errorHandler.onWriteFailure(this.address);
                    return new SessionExpiredException(String.format("Server at %s no longer accepts writes", this.address));
                }
            }
            throw new IllegalArgumentException((Object)((Object)this.accessMode) + " not supported.");
        }
        return e;
    }

    private static boolean isFailureToWrite(ClientException e) {
        String errorCode = e.code();
        return Objects.equals(errorCode, "Neo.ClientError.Cluster.NotALeader") || Objects.equals(errorCode, "Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
    }
}

