/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.outbound;

import java.util.Objects;
import org.neo4j.driver.internal.async.BoltProtocolV1Util;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;

public class ChunkAwareByteBufOutput
implements PackOutput {
    private final int maxChunkSize;
    private ByteBuf buf;
    private int currentChunkStartIndex;
    private int currentChunkSize;

    public ChunkAwareByteBufOutput() {
        this(16383);
    }

    ChunkAwareByteBufOutput(int maxChunkSize) {
        this.maxChunkSize = ChunkAwareByteBufOutput.verifyMaxChunkSize(maxChunkSize);
    }

    public void start(ByteBuf newBuf) {
        this.assertNotStarted();
        this.buf = Objects.requireNonNull(newBuf);
        this.startNewChunk(0);
    }

    public void stop() {
        this.writeChunkSizeHeader();
        this.buf = null;
        this.currentChunkStartIndex = 0;
        this.currentChunkSize = 0;
    }

    @Override
    public PackOutput writeByte(byte value) {
        this.ensureCanFitInCurrentChunk(1);
        this.buf.writeByte(value);
        ++this.currentChunkSize;
        return this;
    }

    @Override
    public PackOutput writeBytes(byte[] data) {
        int amountToWrite;
        int length = data.length;
        for (int offset = 0; offset < length; offset += amountToWrite) {
            this.ensureCanFitInCurrentChunk(1);
            amountToWrite = Math.min(this.availableBytesInCurrentChunk(), length - offset);
            this.buf.writeBytes(data, offset, amountToWrite);
            this.currentChunkSize += amountToWrite;
        }
        return this;
    }

    @Override
    public PackOutput writeShort(short value) {
        this.ensureCanFitInCurrentChunk(2);
        this.buf.writeShort(value);
        this.currentChunkSize += 2;
        return this;
    }

    @Override
    public PackOutput writeInt(int value) {
        this.ensureCanFitInCurrentChunk(4);
        this.buf.writeInt(value);
        this.currentChunkSize += 4;
        return this;
    }

    @Override
    public PackOutput writeLong(long value) {
        this.ensureCanFitInCurrentChunk(8);
        this.buf.writeLong(value);
        this.currentChunkSize += 8;
        return this;
    }

    @Override
    public PackOutput writeDouble(double value) {
        this.ensureCanFitInCurrentChunk(8);
        this.buf.writeDouble(value);
        this.currentChunkSize += 8;
        return this;
    }

    private void ensureCanFitInCurrentChunk(int numberOfBytes) {
        int targetChunkSize = this.currentChunkSize + numberOfBytes;
        if (targetChunkSize > this.maxChunkSize) {
            this.writeChunkSizeHeader();
            this.startNewChunk(this.buf.writerIndex());
        }
    }

    private void startNewChunk(int index) {
        this.currentChunkStartIndex = index;
        BoltProtocolV1Util.writeEmptyChunkHeader(this.buf);
        this.currentChunkSize = 2;
    }

    private void writeChunkSizeHeader() {
        int chunkBodySize = this.currentChunkSize - 2;
        BoltProtocolV1Util.writeChunkHeader(this.buf, this.currentChunkStartIndex, chunkBodySize);
    }

    private int availableBytesInCurrentChunk() {
        return this.maxChunkSize - this.currentChunkSize;
    }

    private void assertNotStarted() {
        if (this.buf != null) {
            throw new IllegalStateException("Already started");
        }
    }

    private static int verifyMaxChunkSize(int maxChunkSize) {
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("Max chunk size should be > 0, given: " + maxChunkSize);
        }
        return maxChunkSize;
    }
}

