/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.v1.Value;

public class BookmarkResponseHandler
implements ResponseHandler {
    private final ExplicitTransaction tx;

    public BookmarkResponseHandler(ExplicitTransaction tx) {
        this.tx = tx;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        Value bookmarkValue = metadata.get("bookmark");
        if (bookmarkValue != null) {
            this.tx.setBookmark(Bookmark.from(bookmarkValue.asString()));
        }
    }

    @Override
    public void onFailure(Throwable error) {
    }

    @Override
    public void onRecord(Value[] fields) {
    }
}

