/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelConnector;
import org.neo4j.driver.internal.async.NettyConnection;
import org.neo4j.driver.internal.async.pool.ActiveChannelTracker;
import org.neo4j.driver.internal.async.pool.NettyChannelHealthChecker;
import org.neo4j.driver.internal.async.pool.NettyChannelPool;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPool;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ClientException;

public class ConnectionPoolImpl
implements ConnectionPool {
    private final ChannelConnector connector;
    private final Bootstrap bootstrap;
    private final ActiveChannelTracker activeChannelTracker;
    private final NettyChannelHealthChecker channelHealthChecker;
    private final PoolSettings settings;
    private final Clock clock;
    private final Logger log;
    private final ConcurrentMap<BoltServerAddress, ChannelPool> pools = new ConcurrentHashMap<BoltServerAddress, ChannelPool>();
    private final AtomicBoolean closed = new AtomicBoolean();

    public ConnectionPoolImpl(ChannelConnector connector, Bootstrap bootstrap, PoolSettings settings, Logging logging, Clock clock) {
        this(connector, bootstrap, new ActiveChannelTracker(logging), settings, logging, clock);
    }

    ConnectionPoolImpl(ChannelConnector connector, Bootstrap bootstrap, ActiveChannelTracker activeChannelTracker, PoolSettings settings, Logging logging, Clock clock) {
        this.connector = connector;
        this.bootstrap = bootstrap;
        this.activeChannelTracker = activeChannelTracker;
        this.channelHealthChecker = new NettyChannelHealthChecker(settings, clock, logging);
        this.settings = settings;
        this.clock = clock;
        this.log = logging.getLog(ConnectionPool.class.getSimpleName());
    }

    @Override
    public CompletionStage<Connection> acquire(BoltServerAddress address) {
        this.log.trace("Acquiring a connection from pool towards %s", address);
        this.assertNotClosed();
        ChannelPool pool = this.getOrCreatePool(address);
        Future<Channel> connectionFuture = pool.acquire();
        return Futures.asCompletionStage(connectionFuture).handle((channel, error) -> {
            this.processAcquisitionError((Throwable)error);
            this.assertNotClosed(address, (Channel)channel, pool);
            return new NettyConnection((Channel)channel, pool, this.clock);
        });
    }

    @Override
    public void retainAll(Set<BoltServerAddress> addressesToRetain) {
        for (BoltServerAddress address : this.pools.keySet()) {
            ChannelPool pool;
            int activeChannels;
            if (addressesToRetain.contains(address) || (activeChannels = this.activeChannelTracker.activeChannelCount(address)) != 0 || (pool = (ChannelPool)this.pools.remove(address)) == null) continue;
            this.log.info("Closing connection pool towards %s, it has no active connections and is not in the routing table", address);
            pool.close();
        }
    }

    @Override
    public int activeConnections(BoltServerAddress address) {
        return this.activeChannelTracker.activeChannelCount(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                for (Map.Entry entry : this.pools.entrySet()) {
                    BoltServerAddress address = (BoltServerAddress)entry.getKey();
                    ChannelPool pool = (ChannelPool)entry.getValue();
                    this.log.info("Closing connection pool towards %s", address);
                    pool.close();
                }
                this.pools.clear();
            }
            finally {
                this.eventLoopGroup().shutdownGracefully();
            }
        }
        return Futures.asCompletionStage(this.eventLoopGroup().terminationFuture()).thenApply(ignore -> null);
    }

    private ChannelPool getOrCreatePool(BoltServerAddress address) {
        ChannelPool pool = (ChannelPool)this.pools.get(address);
        if (pool == null && this.pools.putIfAbsent(address, pool = this.newPool(address)) != null) {
            pool.close();
            return this.getOrCreatePool(address);
        }
        return pool;
    }

    ChannelPool newPool(BoltServerAddress address) {
        return new NettyChannelPool(address, this.connector, this.bootstrap, this.activeChannelTracker, this.channelHealthChecker, this.settings.connectionAcquisitionTimeout(), this.settings.maxConnectionPoolSize());
    }

    private EventLoopGroup eventLoopGroup() {
        return this.bootstrap.config().group();
    }

    private void processAcquisitionError(Throwable error) {
        Throwable cause = Futures.completionExceptionCause(error);
        if (cause != null) {
            if (cause instanceof TimeoutException) {
                throw new ClientException("Unable to acquire connection from the pool within configured maximum time of " + this.settings.connectionAcquisitionTimeout() + "ms");
            }
            throw new CompletionException(cause);
        }
    }

    private void assertNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Pool closed");
        }
    }

    private void assertNotClosed(BoltServerAddress address, Channel channel, ChannelPool pool) {
        if (this.closed.get()) {
            pool.release(channel);
            pool.close();
            this.pools.remove(address);
            this.assertNotClosed();
        }
    }
}

