/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.summary.ResultSummary;

public class InternalStatementResultCursor
implements StatementResultCursor {
    private final RunResponseHandler runResponseHandler;
    private final PullAllResponseHandler pullAllHandler;
    private CompletionStage<Record> peekedRecordFuture;

    public InternalStatementResultCursor(RunResponseHandler runResponseHandler, PullAllResponseHandler pullAllHandler) {
        this.runResponseHandler = Objects.requireNonNull(runResponseHandler);
        this.pullAllHandler = Objects.requireNonNull(pullAllHandler);
    }

    @Override
    public List<String> keys() {
        List<String> keys = this.runResponseHandler.statementKeys();
        return keys == null ? Collections.emptyList() : Collections.unmodifiableList(keys);
    }

    @Override
    public CompletionStage<ResultSummary> summaryAsync() {
        return this.pullAllHandler.summaryAsync();
    }

    @Override
    public CompletionStage<Record> nextAsync() {
        if (this.peekedRecordFuture != null) {
            CompletionStage<Record> result = this.peekedRecordFuture;
            this.peekedRecordFuture = null;
            return result;
        }
        return this.pullAllHandler.nextAsync();
    }

    @Override
    public CompletionStage<Record> peekAsync() {
        if (this.peekedRecordFuture == null) {
            this.peekedRecordFuture = this.pullAllHandler.nextAsync();
        }
        return this.peekedRecordFuture;
    }

    @Override
    public CompletionStage<Void> forEachAsync(Consumer<Record> action) {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        this.internalForEachAsync(action, resultFuture);
        return resultFuture;
    }

    @Override
    public CompletionStage<List<Record>> listAsync() {
        CompletableFuture<List<Record>> resultFuture = new CompletableFuture<List<Record>>();
        this.internalListAsync(new ArrayList<Record>(), resultFuture);
        return resultFuture;
    }

    private void internalForEachAsync(Consumer<Record> action, CompletableFuture<Void> resultFuture) {
        CompletionStage<Record> recordFuture = this.nextAsync();
        recordFuture.whenCompleteAsync((record, error) -> {
            if (error != null) {
                resultFuture.completeExceptionally((Throwable)error);
            } else if (record != null) {
                action.accept((Record)record);
                this.internalForEachAsync(action, resultFuture);
            } else {
                resultFuture.complete(null);
            }
        });
    }

    private void internalListAsync(List<Record> records, CompletableFuture<List<Record>> resultFuture) {
        CompletionStage<Record> recordFuture = this.nextAsync();
        recordFuture.whenCompleteAsync((record, error) -> {
            if (error != null) {
                resultFuture.completeExceptionally((Throwable)error);
            } else if (record != null) {
                records.add((Record)record);
                this.internalListAsync(records, resultFuture);
            } else {
                resultFuture.complete(records);
            }
        });
    }
}

