/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.async.AsyncConnector;
import org.neo4j.driver.internal.async.ChannelConnectedListener;
import org.neo4j.driver.internal.async.HandshakeCompletedListener;
import org.neo4j.driver.internal.async.NettyChannelInitializer;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class AsyncConnectorImpl
implements AsyncConnector {
    private final String userAgent;
    private final Map<String, Value> authToken;
    private final SecurityPlan securityPlan;
    private final int connectTimeoutMillis;
    private final ChannelPoolHandler channelPoolHandler;
    private final Logging logging;
    private final Clock clock;

    public AsyncConnectorImpl(ConnectionSettings connectionSettings, SecurityPlan securityPlan, ChannelPoolHandler channelPoolHandler, Logging logging, Clock clock) {
        this.userAgent = connectionSettings.userAgent();
        this.authToken = AsyncConnectorImpl.tokenAsMap(connectionSettings.authToken());
        this.connectTimeoutMillis = connectionSettings.connectTimeoutMillis();
        this.securityPlan = Objects.requireNonNull(securityPlan);
        this.channelPoolHandler = Objects.requireNonNull(channelPoolHandler);
        this.logging = Objects.requireNonNull(logging);
        this.clock = Objects.requireNonNull(clock);
    }

    @Override
    public ChannelFuture connect(BoltServerAddress address, Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeoutMillis);
        bootstrap.handler((ChannelHandler)new NettyChannelInitializer(address, this.securityPlan, this.channelPoolHandler, this.clock));
        ChannelFuture channelConnected = bootstrap.connect(address.toSocketAddress());
        Channel channel = channelConnected.channel();
        ChannelPromise handshakeCompleted = channel.newPromise();
        ChannelPromise connectionInitialized = channel.newPromise();
        channelConnected.addListener((GenericFutureListener)new ChannelConnectedListener(address, handshakeCompleted, this.logging));
        handshakeCompleted.addListener((GenericFutureListener)new HandshakeCompletedListener(this.userAgent, this.authToken, connectionInitialized));
        return connectionInitialized;
    }

    private static Map<String, Value> tokenAsMap(AuthToken token) {
        if (token instanceof InternalAuthToken) {
            return ((InternalAuthToken)token).toMap();
        }
        throw new ClientException("Unknown authentication token, `" + token + "`. Please use one of the supported tokens from `" + AuthTokens.class.getSimpleName() + "`.");
    }
}

