/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.neo4j.driver.ResultResourcesHandler;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.async.AsyncConnection;
import org.neo4j.driver.internal.async.Futures;
import org.neo4j.driver.internal.async.QueryRunner;
import org.neo4j.driver.internal.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.handlers.BookmarkResponseHandler;
import org.neo4j.driver.internal.handlers.CommitTxResponseHandler;
import org.neo4j.driver.internal.handlers.NoOpResponseHandler;
import org.neo4j.driver.internal.handlers.RollbackTxResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.types.TypeSystem;

public class ExplicitTransaction
implements Transaction,
ResultResourcesHandler {
    private static final String BEGIN_QUERY = "BEGIN";
    private static final String COMMIT_QUERY = "COMMIT";
    private static final String ROLLBACK_QUERY = "ROLLBACK";
    private final SessionResourcesHandler resourcesHandler;
    private final Connection connection;
    private final AsyncConnection asyncConnection;
    private final NetworkSession session;
    private volatile Bookmark bookmark = Bookmark.empty();
    private volatile State state = State.ACTIVE;

    public ExplicitTransaction(Connection connection, SessionResourcesHandler resourcesHandler) {
        this.connection = connection;
        this.asyncConnection = null;
        this.session = null;
        this.resourcesHandler = resourcesHandler;
    }

    public ExplicitTransaction(AsyncConnection asyncConnection, NetworkSession session) {
        this.connection = null;
        this.asyncConnection = asyncConnection;
        this.session = session;
        this.resourcesHandler = SessionResourcesHandler.NO_OP;
    }

    public void begin(Bookmark initialBookmark) {
        Map<String, Value> parameters = initialBookmark.asBeginTransactionParameters();
        this.connection.run(BEGIN_QUERY, parameters, NoOpResponseHandler.INSTANCE);
        this.connection.pullAll(NoOpResponseHandler.INSTANCE);
        if (!initialBookmark.isEmpty()) {
            this.connection.sync();
        }
    }

    public CompletionStage<ExplicitTransaction> beginAsync(Bookmark initialBookmark) {
        if (initialBookmark.isEmpty()) {
            this.asyncConnection.run(BEGIN_QUERY, Collections.emptyMap(), NoOpResponseHandler.INSTANCE, NoOpResponseHandler.INSTANCE);
            return CompletableFuture.completedFuture(this);
        }
        CompletableFuture<ExplicitTransaction> beginFuture = new CompletableFuture<ExplicitTransaction>();
        this.asyncConnection.runAndFlush(BEGIN_QUERY, initialBookmark.asBeginTransactionParameters(), NoOpResponseHandler.INSTANCE, new BeginTxResponseHandler<ExplicitTransaction>(beginFuture, this));
        return beginFuture;
    }

    @Override
    public void success() {
        if (this.state == State.ACTIVE) {
            this.state = State.MARKED_SUCCESS;
        }
    }

    @Override
    public void failure() {
        if (this.state == State.ACTIVE || this.state == State.MARKED_SUCCESS) {
            this.state = State.MARKED_FAILED;
        }
    }

    @Override
    public void close() {
        block11: {
            try {
                if (this.connection == null || !this.connection.isOpen()) break block11;
                if (this.state == State.MARKED_SUCCESS) {
                    try {
                        this.connection.run(COMMIT_QUERY, Collections.emptyMap(), NoOpResponseHandler.INSTANCE);
                        this.connection.pullAll(new BookmarkResponseHandler(this));
                        this.connection.sync();
                        this.state = State.COMMITTED;
                        break block11;
                    }
                    catch (Throwable e) {
                        try {
                            this.rollbackTx();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
                if (this.state == State.MARKED_FAILED || this.state == State.ACTIVE) {
                    this.rollbackTx();
                } else if (this.state == State.FAILED) {
                    this.state = State.ROLLED_BACK;
                }
            }
            finally {
                this.resourcesHandler.onTransactionClosed(this);
            }
        }
    }

    private void rollbackTx() {
        this.connection.run(ROLLBACK_QUERY, Collections.emptyMap(), NoOpResponseHandler.INSTANCE);
        this.connection.pullAll(new BookmarkResponseHandler(this));
        this.connection.sync();
        this.state = State.ROLLED_BACK;
    }

    @Override
    public CompletionStage<Void> commitAsync() {
        if (this.state == State.COMMITTED) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.state == State.ROLLED_BACK) {
            return Futures.failedFuture(new ClientException("Can't commit, transaction has already been rolled back"));
        }
        return this.doCommitAsync().whenComplete(this.releaseConnectionAndNotifySession());
    }

    @Override
    public CompletionStage<Void> rollbackAsync() {
        if (this.state == State.COMMITTED) {
            return Futures.failedFuture(new ClientException("Can't rollback, transaction has already been committed"));
        }
        if (this.state == State.ROLLED_BACK) {
            return CompletableFuture.completedFuture(null);
        }
        return this.doRollbackAsync().whenComplete(this.releaseConnectionAndNotifySession());
    }

    private BiConsumer<Void, Throwable> releaseConnectionAndNotifySession() {
        return (ignore, error) -> {
            this.asyncConnection.release();
            this.session.asyncTransactionClosed(this);
        };
    }

    private CompletionStage<Void> doCommitAsync() {
        CompletableFuture<Void> commitFuture = new CompletableFuture<Void>();
        this.asyncConnection.runAndFlush(COMMIT_QUERY, Collections.emptyMap(), NoOpResponseHandler.INSTANCE, new CommitTxResponseHandler(commitFuture, this));
        return commitFuture.thenApply(ignore -> {
            this.state = State.COMMITTED;
            return null;
        });
    }

    private CompletionStage<Void> doRollbackAsync() {
        CompletableFuture<Void> rollbackFuture = new CompletableFuture<Void>();
        this.asyncConnection.runAndFlush(ROLLBACK_QUERY, Collections.emptyMap(), NoOpResponseHandler.INSTANCE, new RollbackTxResponseHandler(rollbackFuture));
        return rollbackFuture.thenApply(ignore -> {
            this.state = State.ROLLED_BACK;
            return null;
        });
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementText, Value parameters) {
        return this.runAsync(new Statement(statementText, parameters));
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementTemplate) {
        return this.runAsync(statementTemplate, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementTemplate, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.runAsync(statementTemplate, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.runAsync(statementTemplate, params);
    }

    @Override
    public StatementResult run(Statement statement) {
        this.ensureNotFailed();
        try {
            InternalStatementResult result = new InternalStatementResult(statement, this.connection, ResultResourcesHandler.NO_OP);
            this.connection.run(statement.text(), statement.parameters().asMap(Values.ofValue()), result.runResponseHandler());
            this.connection.pullAll(result.pullAllResponseHandler());
            this.connection.flush();
            return result;
        }
        catch (Neo4jException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement) {
        this.ensureNotFailed();
        return QueryRunner.runAsync(this.asyncConnection, statement, this);
    }

    @Override
    public boolean isOpen() {
        return this.state != State.COMMITTED && this.state != State.ROLLED_BACK;
    }

    private void ensureNotFailed() {
        if (this.state == State.FAILED || this.state == State.MARKED_FAILED || this.state == State.ROLLED_BACK) {
            throw new ClientException("Cannot run more statements in this transaction, because previous statements in the transaction has failed and the transaction has been rolled back. Please start a new transaction to run another statement.");
        }
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    @Override
    public void resultFetched() {
    }

    @Override
    public void resultFailed(Throwable error) {
        if (ErrorUtil.isRecoverable(error)) {
            this.failure();
        } else {
            this.markToClose();
        }
    }

    public void markToClose() {
        this.state = State.FAILED;
    }

    public Bookmark bookmark() {
        return this.bookmark;
    }

    public void setBookmark(Bookmark bookmark) {
        if (bookmark != null && !bookmark.isEmpty()) {
            this.bookmark = bookmark;
        }
    }

    private static enum State {
        ACTIVE,
        MARKED_SUCCESS,
        MARKED_FAILED,
        FAILED,
        COMMITTED,
        ROLLED_BACK;

    }
}

