/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import java.util.Set;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.cluster.AddressSet;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.DnsResolver;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoutingPooledConnection;
import org.neo4j.driver.internal.cluster.RoutingProcedureClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;

public class LoadBalancer
implements ConnectionProvider,
RoutingErrorHandler,
AutoCloseable {
    private static final String LOAD_BALANCER_LOG_NAME = "LoadBalancer";
    private final ConnectionPool connections;
    private final RoutingTable routingTable;
    private final Rediscovery rediscovery;
    private final LoadBalancingStrategy loadBalancingStrategy;
    private final Logger log;

    public LoadBalancer(BoltServerAddress initialRouter, RoutingSettings settings, ConnectionPool connections, Clock clock, Logging logging, LoadBalancingStrategy loadBalancingStrategy) {
        this(connections, new ClusterRoutingTable(clock, initialRouter), LoadBalancer.createRediscovery(initialRouter, settings, clock, logging), LoadBalancer.loadBalancerLogger(logging), loadBalancingStrategy);
    }

    public LoadBalancer(ConnectionPool connections, RoutingTable routingTable, Rediscovery rediscovery, Logging logging) {
        this(connections, routingTable, rediscovery, LoadBalancer.loadBalancerLogger(logging), new LeastConnectedLoadBalancingStrategy(connections, logging));
    }

    private LoadBalancer(ConnectionPool connections, RoutingTable routingTable, Rediscovery rediscovery, Logger log, LoadBalancingStrategy loadBalancingStrategy) {
        this.connections = connections;
        this.routingTable = routingTable;
        this.rediscovery = rediscovery;
        this.loadBalancingStrategy = loadBalancingStrategy;
        this.log = log;
        this.refreshRoutingTable();
    }

    @Override
    public PooledConnection acquireConnection(AccessMode mode) {
        AddressSet addressSet = this.addressSetFor(mode);
        PooledConnection connection = this.acquireConnection(mode, addressSet);
        return new RoutingPooledConnection(connection, this, mode);
    }

    @Override
    public void onConnectionFailure(BoltServerAddress address) {
        this.forget(address);
    }

    @Override
    public void onWriteFailure(BoltServerAddress address) {
        this.routingTable.removeWriter(address);
    }

    @Override
    public void close() throws Exception {
        this.connections.close();
    }

    private PooledConnection acquireConnection(AccessMode mode, AddressSet servers) {
        BoltServerAddress address;
        this.ensureRouting(mode);
        while ((address = this.selectAddress(mode, servers)) != null) {
            try {
                return this.connections.acquire(address);
            }
            catch (ServiceUnavailableException e) {
                this.log.error("Failed to obtain a connection towards address " + address, e);
                this.forget(address);
            }
        }
        throw new SessionExpiredException("Failed to obtain connection towards " + (Object)((Object)mode) + " server. Known routing table is: " + this.routingTable);
    }

    private synchronized void forget(BoltServerAddress address) {
        this.routingTable.forget(address);
        this.connections.purge(address);
    }

    synchronized void ensureRouting(AccessMode mode) {
        if (this.routingTable.isStaleFor(mode)) {
            this.refreshRoutingTable();
        }
    }

    synchronized void refreshRoutingTable() {
        this.log.info("Routing information is stale. %s", this.routingTable);
        ClusterComposition cluster = this.rediscovery.lookupClusterComposition(this.routingTable, this.connections);
        Set<BoltServerAddress> removed = this.routingTable.update(cluster);
        for (BoltServerAddress address : removed) {
            this.connections.purge(address);
        }
        this.log.info("Refreshed routing information. %s", this.routingTable);
    }

    private AddressSet addressSetFor(AccessMode mode) {
        switch (mode) {
            case READ: {
                return this.routingTable.readers();
            }
            case WRITE: {
                return this.routingTable.writers();
            }
        }
        throw LoadBalancer.unknownMode(mode);
    }

    private BoltServerAddress selectAddress(AccessMode mode, AddressSet servers) {
        BoltServerAddress[] addresses = servers.toArray();
        switch (mode) {
            case READ: {
                return this.loadBalancingStrategy.selectReader(addresses);
            }
            case WRITE: {
                return this.loadBalancingStrategy.selectWriter(addresses);
            }
        }
        throw LoadBalancer.unknownMode(mode);
    }

    private static Rediscovery createRediscovery(BoltServerAddress initialRouter, RoutingSettings settings, Clock clock, Logging logging) {
        Logger log = LoadBalancer.loadBalancerLogger(logging);
        RoutingProcedureClusterCompositionProvider clusterComposition = new RoutingProcedureClusterCompositionProvider(clock, log, settings);
        return new Rediscovery(initialRouter, settings, clock, log, clusterComposition, new DnsResolver(log));
    }

    private static Logger loadBalancerLogger(Logging logging) {
        return logging.getLog(LOAD_BALANCER_LOG_NAME);
    }

    private static RuntimeException unknownMode(AccessMode mode) {
        return new IllegalArgumentException("Mode '" + (Object)((Object)mode) + "' is not supported");
    }
}

