/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.logging.DelegatingLogger;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.util.Supplier;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class BlockingPooledConnectionQueue {
    public static final String LOG_NAME = "ConnectionQueue";
    private final BlockingQueue<PooledConnection> queue;
    private final Logger logger;
    private final AtomicBoolean isDeactivated = new AtomicBoolean(false);
    private final AtomicBoolean isTerminating = new AtomicBoolean(false);
    private final Set<PooledConnection> acquiredConnections = Collections.newSetFromMap(new ConcurrentHashMap());

    public BlockingPooledConnectionQueue(BoltServerAddress address, int capacity, Logging logging) {
        this.queue = new LinkedBlockingQueue<PooledConnection>(capacity);
        this.logger = BlockingPooledConnectionQueue.createLogger(address, logging);
    }

    public boolean offer(PooledConnection pooledConnection) {
        this.acquiredConnections.remove(pooledConnection);
        boolean offer = this.queue.offer(pooledConnection);
        if (!offer) {
            this.disposeSafely(pooledConnection);
        }
        if (this.isDeactivated.get() || this.isTerminating.get()) {
            this.terminateIdleConnections();
        }
        return offer;
    }

    public PooledConnection acquire(Supplier<PooledConnection> supplier) {
        PooledConnection connection = (PooledConnection)this.queue.poll();
        if (connection == null) {
            connection = supplier.get();
        }
        this.acquiredConnections.add(connection);
        if (this.isDeactivated.get() || this.isTerminating.get()) {
            this.acquiredConnections.remove(connection);
            this.disposeSafely(connection);
            throw new IllegalStateException("Pool is " + (this.isDeactivated.get() ? "deactivated" : "terminated") + ", " + "new connections can't be acquired");
        }
        return connection;
    }

    public int idleConnections() {
        return this.queue.size();
    }

    public int activeConnections() {
        return this.acquiredConnections.size();
    }

    void disposeBroken(PooledConnection connection) {
        this.acquiredConnections.remove(connection);
        this.disposeSafely(connection);
    }

    public boolean contains(PooledConnection pooledConnection) {
        return this.queue.contains(pooledConnection);
    }

    public void activate() {
        this.isDeactivated.compareAndSet(true, false);
    }

    public void deactivate() {
        if (this.isDeactivated.compareAndSet(false, true)) {
            this.terminateIdleConnections();
        }
    }

    public boolean isActive() {
        return !this.isDeactivated.get();
    }

    public void terminate() {
        if (this.isTerminating.compareAndSet(false, true)) {
            this.terminateIdleConnections();
            this.terminateAcquiredConnections();
        }
    }

    private void terminateIdleConnections() {
        while (!this.queue.isEmpty()) {
            PooledConnection idleConnection = (PooledConnection)this.queue.poll();
            this.disposeSafely(idleConnection);
        }
    }

    private void terminateAcquiredConnections() {
        for (PooledConnection acquiredConnection : this.acquiredConnections) {
            this.disposeSafely(acquiredConnection);
        }
    }

    private void disposeSafely(PooledConnection connection) {
        try {
            if (connection != null) {
                connection.dispose();
            }
        }
        catch (Throwable disposeError) {
            this.logger.error("Error disposing connection", disposeError);
        }
    }

    private static Logger createLogger(BoltServerAddress address, Logging logging) {
        return new DelegatingLogger(logging.getLog(LOG_NAME), address.toString());
    }
}

