/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.DnsResolver;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoundRobinAddressSet;
import org.neo4j.driver.internal.cluster.RoutingPooledConnection;
import org.neo4j.driver.internal.cluster.RoutingProcedureClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.RoutingTableChange;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;

public class LoadBalancer
implements ConnectionProvider,
RoutingErrorHandler,
AutoCloseable {
    private static final String LOAD_BALANCER_LOG_NAME = "LoadBalancer";
    private static final boolean PURGE_ON_ERROR = Boolean.getBoolean("purgeOnError");
    private final ConnectionPool connections;
    private final RoutingTable routingTable;
    private final Rediscovery rediscovery;
    private final Logger log;

    public LoadBalancer(BoltServerAddress initialRouter, RoutingSettings settings, ConnectionPool connections, Clock clock, Logging logging) {
        this(initialRouter, settings, connections, new ClusterRoutingTable(clock, initialRouter), clock, logging.getLog(LOAD_BALANCER_LOG_NAME));
    }

    private LoadBalancer(BoltServerAddress initialRouter, RoutingSettings settings, ConnectionPool connections, RoutingTable routingTable, Clock clock, Logger log) {
        this(connections, routingTable, LoadBalancer.createRediscovery(initialRouter, settings, clock, log), log);
    }

    LoadBalancer(ConnectionPool connections, RoutingTable routingTable, Rediscovery rediscovery, Logger log) {
        this.connections = connections;
        this.routingTable = routingTable;
        this.rediscovery = rediscovery;
        this.log = log;
        this.refreshRoutingTable();
    }

    @Override
    public PooledConnection acquireConnection(AccessMode mode) {
        RoundRobinAddressSet addressSet = this.addressSetFor(mode);
        PooledConnection connection = this.acquireConnection(mode, addressSet);
        return new RoutingPooledConnection(connection, this, mode);
    }

    @Override
    public void onConnectionFailure(BoltServerAddress address) {
        this.forget(address);
    }

    @Override
    public void onWriteFailure(BoltServerAddress address) {
        this.routingTable.removeWriter(address);
    }

    @Override
    public void close() throws Exception {
        this.connections.close();
    }

    private PooledConnection acquireConnection(AccessMode mode, RoundRobinAddressSet servers) {
        BoltServerAddress address;
        this.ensureRouting(mode);
        while ((address = servers.next()) != null) {
            try {
                return this.connections.acquire(address);
            }
            catch (ServiceUnavailableException e) {
                this.log.error("Failed to obtain a connection towards address " + address, e);
                this.forget(address);
            }
        }
        throw new SessionExpiredException("Failed to obtain connection towards " + (Object)((Object)mode) + " server. Known routing table is: " + this.routingTable);
    }

    private synchronized void forget(BoltServerAddress address) {
        this.routingTable.forget(address);
        if (PURGE_ON_ERROR) {
            this.connections.purge(address);
        } else {
            this.connections.deactivate(address);
        }
    }

    synchronized void ensureRouting(AccessMode mode) {
        if (this.routingTable.isStaleFor(mode)) {
            this.refreshRoutingTable();
        }
    }

    synchronized void refreshRoutingTable() {
        this.log.info("Routing information is stale. %s", this.routingTable);
        ClusterComposition cluster = this.rediscovery.lookupClusterComposition(this.routingTable, this.connections);
        RoutingTableChange routingTableChange = this.routingTable.update(cluster);
        this.updateConnectionPool(routingTableChange);
        this.log.info("Refreshed routing information. %s", this.routingTable);
    }

    private void updateConnectionPool(RoutingTableChange routingTableChange) {
        if (PURGE_ON_ERROR) {
            for (BoltServerAddress removedAddress : routingTableChange.removed()) {
                this.connections.purge(removedAddress);
            }
        } else {
            for (BoltServerAddress addedAddress : routingTableChange.added()) {
                this.connections.activate(addedAddress);
            }
            for (BoltServerAddress removedAddress : routingTableChange.removed()) {
                this.connections.deactivate(removedAddress);
            }
            this.connections.compact();
        }
    }

    private RoundRobinAddressSet addressSetFor(AccessMode mode) {
        switch (mode) {
            case READ: {
                return this.routingTable.readers();
            }
            case WRITE: {
                return this.routingTable.writers();
            }
        }
        throw new IllegalArgumentException("Mode '" + (Object)((Object)mode) + "' is not supported");
    }

    private static Rediscovery createRediscovery(BoltServerAddress initialRouter, RoutingSettings settings, Clock clock, Logger log) {
        RoutingProcedureClusterCompositionProvider clusterComposition = new RoutingProcedureClusterCompositionProvider(clock, log, settings);
        return new Rediscovery(initialRouter, settings, clock, log, clusterComposition, new DnsResolver(log));
    }
}

