/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.RoundRobinAddressSet;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.RoutingTableChange;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AccessMode;

public class ClusterRoutingTable
implements RoutingTable {
    private static final int MIN_ROUTERS = 1;
    private final Clock clock;
    private volatile long expirationTimeout;
    private final RoundRobinAddressSet readers;
    private final RoundRobinAddressSet writers;
    private final RoundRobinAddressSet routers;

    public ClusterRoutingTable(Clock clock, BoltServerAddress ... routingAddresses) {
        this(clock);
        this.routers.update(new LinkedHashSet<BoltServerAddress>(Arrays.asList(routingAddresses)));
    }

    private ClusterRoutingTable(Clock clock) {
        this.clock = clock;
        this.expirationTimeout = clock.millis() - 1L;
        this.readers = new RoundRobinAddressSet();
        this.writers = new RoundRobinAddressSet();
        this.routers = new RoundRobinAddressSet();
    }

    @Override
    public boolean isStaleFor(AccessMode mode) {
        return this.expirationTimeout < this.clock.millis() || this.routers.size() < 1 || mode == AccessMode.READ && this.readers.size() == 0 || mode == AccessMode.WRITE && this.writers.size() == 0;
    }

    private Set<BoltServerAddress> servers() {
        HashSet<BoltServerAddress> servers = new HashSet<BoltServerAddress>();
        servers.addAll(this.readers.servers());
        servers.addAll(this.writers.servers());
        servers.addAll(this.routers.servers());
        return servers;
    }

    @Override
    public synchronized RoutingTableChange update(ClusterComposition cluster) {
        this.expirationTimeout = cluster.expirationTimestamp();
        Set<BoltServerAddress> previousServers = this.servers();
        this.readers.update(cluster.readers());
        this.writers.update(cluster.writers());
        this.routers.update(cluster.routers());
        Set<BoltServerAddress> currentServers = this.servers();
        HashSet<BoltServerAddress> added = new HashSet<BoltServerAddress>(currentServers);
        HashSet<BoltServerAddress> removed = new HashSet<BoltServerAddress>(previousServers);
        added.removeAll(previousServers);
        removed.removeAll(currentServers);
        return new RoutingTableChange(added, removed);
    }

    @Override
    public synchronized void forget(BoltServerAddress address) {
        this.routers.remove(address);
        this.readers.remove(address);
        this.writers.remove(address);
    }

    @Override
    public RoundRobinAddressSet readers() {
        return this.readers;
    }

    @Override
    public RoundRobinAddressSet writers() {
        return this.writers;
    }

    @Override
    public BoltServerAddress nextRouter() {
        return this.routers.next();
    }

    @Override
    public int routerSize() {
        return this.routers.size();
    }

    @Override
    public void removeWriter(BoltServerAddress toRemove) {
        this.writers.remove(toRemove);
    }

    public synchronized String toString() {
        return String.format("Ttl %s, currentTime %s, routers %s, writers %s, readers %s", this.expirationTimeout, this.clock.millis(), this.routers, this.writers, this.readers);
    }
}

