/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.spi;

import java.util.List;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.StatementType;
import org.neo4j.driver.v1.summary.SummaryCounters;

public interface Collector {
    public static final Collector NO_OP = new NoOperationCollector();
    public static final Collector ACK_FAILURE = new NoOperationCollector(){

        @Override
        public void doneFailure(Neo4jException error) {
            throw new ClientException("Invalid server response message `FAILURE` received for client message `ACK_FAILURE`.", error);
        }
    };
    public static final Collector RESET = new ResetCollector();

    public void keys(String[] var1);

    public void record(Value[] var1);

    public void statementType(StatementType var1);

    public void statementStatistics(SummaryCounters var1);

    public void plan(Plan var1);

    public void profile(ProfiledPlan var1);

    public void notifications(List<Notification> var1);

    public void bookmark(Bookmark var1);

    public void done();

    public void doneSuccess();

    public void doneFailure(Neo4jException var1);

    public void doneIgnored();

    public void resultAvailableAfter(long var1);

    public void resultConsumedAfter(long var1);

    public void serverVersion(String var1);

    public static class NoOperationCollector
    implements Collector {
        @Override
        public void keys(String[] names) {
        }

        @Override
        public void record(Value[] fields) {
        }

        @Override
        public void statementType(StatementType type) {
        }

        @Override
        public void statementStatistics(SummaryCounters statistics) {
        }

        @Override
        public void plan(Plan plan) {
        }

        @Override
        public void profile(ProfiledPlan plan) {
        }

        @Override
        public void notifications(List<Notification> notifications) {
        }

        @Override
        public void bookmark(Bookmark bookmark) {
        }

        @Override
        public void done() {
        }

        @Override
        public void doneSuccess() {
            this.done();
        }

        @Override
        public void doneFailure(Neo4jException error) {
            this.done();
        }

        @Override
        public void doneIgnored() {
            this.done();
        }

        @Override
        public void resultAvailableAfter(long l) {
        }

        @Override
        public void resultConsumedAfter(long l) {
        }

        @Override
        public void serverVersion(String server) {
        }
    }

    public static class ResetCollector
    extends NoOperationCollector {
        private final Runnable doneSuccessCallBack;

        public ResetCollector() {
            this(null);
        }

        public ResetCollector(Runnable doneSuccessCallBack) {
            this.doneSuccessCallBack = doneSuccessCallBack;
        }

        @Override
        public void doneFailure(Neo4jException error) {
            throw new ClientException("Invalid server response message `FAILURE` received for client message `RESET`.", error);
        }

        @Override
        public void doneIgnored() {
            throw new ClientException("Invalid server response message `IGNORED` received for client message `RESET`.");
        }

        @Override
        public void doneSuccess() {
            if (this.doneSuccessCallBack != null) {
                this.doneSuccessCallBack.run();
            }
        }
    }

    public static class InitCollector
    extends NoOperationCollector {
        private String serverVersion;

        @Override
        public void doneIgnored() {
            throw new ClientException("Invalid server response message `IGNORED` received for client message `INIT`.");
        }

        @Override
        public void serverVersion(String serverVersion) {
            this.serverVersion = serverVersion;
        }

        public String serverVersion() {
            return this.serverVersion;
        }
    }
}

