/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import org.neo4j.driver.internal.net.pooling.BlockingPooledConnectionQueue;
import org.neo4j.driver.internal.spi.ConnectionValidator;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.util.Consumer;

class PooledConnectionReleaseConsumer
implements Consumer<PooledConnection> {
    private final BlockingPooledConnectionQueue connections;
    private final ConnectionValidator<PooledConnection> connectionValidator;

    PooledConnectionReleaseConsumer(BlockingPooledConnectionQueue connections, ConnectionValidator<PooledConnection> connectionValidator) {
        this.connections = connections;
        this.connectionValidator = connectionValidator;
    }

    @Override
    public void accept(PooledConnection pooledConnection) {
        if (this.connectionValidator.isReusable(pooledConnection)) {
            this.connections.offer(pooledConnection);
        } else {
            this.connections.disposeBroken(pooledConnection);
        }
    }
}

