/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.v1.AccessMode;

public class DirectConnectionProvider
implements ConnectionProvider {
    private final BoltServerAddress address;
    private final ConnectionPool pool;

    DirectConnectionProvider(BoltServerAddress address, ConnectionPool pool) {
        this.address = address;
        this.pool = pool;
        this.verifyConnectivity();
    }

    @Override
    public PooledConnection acquireConnection(AccessMode mode) {
        return this.pool.acquire(this.address);
    }

    @Override
    public void close() throws Exception {
        this.pool.close();
    }

    public BoltServerAddress getAddress() {
        return this.address;
    }

    private void verifyConnectivity() {
        this.acquireConnection(AccessMode.READ).close();
    }
}

