/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.ClusterCompositionResponse;
import org.neo4j.driver.internal.cluster.RoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ProtocolException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.value.ValueException;

public class RoutingProcedureClusterCompositionProvider
implements ClusterCompositionProvider {
    private static final String PROTOCOL_ERROR_MESSAGE = "Failed to parse '%s' result received from server due to ";
    private final Clock clock;
    private final Logger log;
    private final RoutingProcedureRunner getServersRunner;

    public RoutingProcedureClusterCompositionProvider(Clock clock, Logger log, RoutingSettings settings) {
        this(clock, log, new RoutingProcedureRunner(settings.routingContext()));
    }

    RoutingProcedureClusterCompositionProvider(Clock clock, Logger log, RoutingProcedureRunner getServersRunner) {
        this.clock = clock;
        this.log = log;
        this.getServersRunner = getServersRunner;
    }

    @Override
    public ClusterCompositionResponse getClusterComposition(Connection connection) {
        ClusterComposition cluster;
        List<Record> records;
        try {
            records = this.getServersRunner.run(connection);
        }
        catch (ClientException e) {
            return new ClusterCompositionResponse.Failure(new ServiceUnavailableException(String.format("Failed to run '%s' on server. Please make sure that there is a Neo4j 3.1+ causal cluster up running.", this.invokedProcedureString()), e));
        }
        this.log.info("Got getServers response: %s", records);
        long now = this.clock.millis();
        if (records.size() != 1) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("Failed to parse '%s' result received from server due to records received '%s' is too few or too many.", this.invokedProcedureString(), records.size())));
        }
        try {
            cluster = ClusterComposition.parse(records.get(0), now);
        }
        catch (ValueException e) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("Failed to parse '%s' result received from server due to unparsable record received.", this.invokedProcedureString()), e));
        }
        if (!cluster.hasRoutersAndReaders()) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("Failed to parse '%s' result received from server due to no router or reader found in response.", this.invokedProcedureString())));
        }
        return new ClusterCompositionResponse.Success(cluster);
    }

    private String invokedProcedureString() {
        Statement statement = this.getServersRunner.invokedProcedure();
        return statement.text() + " " + statement.parameters();
    }
}

