/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionValidator;
import org.neo4j.driver.internal.spi.PooledConnection;

class PooledConnectionValidator
implements ConnectionValidator<PooledConnection> {
    private final ConnectionPool pool;

    PooledConnectionValidator(ConnectionPool pool) {
        this.pool = pool;
    }

    @Override
    public boolean isReusable(PooledConnection pooledConnection) {
        return this.pool.hasAddress(pooledConnection.boltServerAddress()) && !pooledConnection.hasUnrecoverableErrors() && this.isConnected(pooledConnection);
    }

    @Override
    public boolean isConnected(PooledConnection connection) {
        try {
            connection.reset();
            connection.sync();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

