/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Session;

public class ConnectionSettings {
    private static final String DEFAULT_USER_AGENT = String.format("neo4j-java/%s", ConnectionSettings.driverVersion());
    private final AuthToken authToken;
    private final String userAgent;
    private final int timeoutMillis;

    private static String driverVersion() {
        Package pkg = Session.class.getPackage();
        if (pkg != null && pkg.getImplementationVersion() != null) {
            return pkg.getImplementationVersion();
        }
        return "dev";
    }

    public ConnectionSettings(AuthToken authToken, String userAgent, int timeoutMillis) {
        this.authToken = authToken;
        this.userAgent = userAgent;
        this.timeoutMillis = timeoutMillis;
    }

    public ConnectionSettings(AuthToken authToken, int timeoutMillis) {
        this(authToken, DEFAULT_USER_AGENT, timeoutMillis);
    }

    public AuthToken authToken() {
        return this.authToken;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public int timeoutMillis() {
        return this.timeoutMillis;
    }
}

