/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Values;

public class GetServersProcedureRunner {
    static final String GET_SERVERS = "dbms.cluster.routing.getServers";
    static final String GET_ROUTING_TABLE_PARAM = "context";
    static final String GET_ROUTING_TABLE = "dbms.cluster.routing.getRoutingTable({context})";
    private final Map<String, String> routingContext;
    private Statement procedureCalled;

    public GetServersProcedureRunner(Map<String, String> context) {
        this.routingContext = context;
    }

    public List<Record> run(Connection connection) {
        this.procedureCalled = ServerVersion.version(connection.server().version()).greaterThanOrEqual(ServerVersion.v3_2_0) ? new Statement("CALL dbms.cluster.routing.getRoutingTable({context})", Values.parameters(GET_ROUTING_TABLE_PARAM, this.routingContext)) : new Statement("CALL dbms.cluster.routing.getServers");
        return this.runProcedure(connection, this.procedureCalled);
    }

    List<Record> runProcedure(Connection connection, Statement procedure) {
        return NetworkSession.run(connection, procedure, SessionResourcesHandler.NO_OP).list();
    }

    Statement procedureCalled() {
        return this.procedureCalled;
    }
}

