/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.spi.Collector;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.summary.SummaryBuilder;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.summary.ServerInfo;
import org.neo4j.driver.v1.summary.StatementType;
import org.neo4j.driver.v1.summary.SummaryCounters;
import org.neo4j.driver.v1.util.Function;
import org.neo4j.driver.v1.util.Functions;

public class InternalStatementResult
implements StatementResult {
    private final Connection connection;
    private final SessionResourcesHandler resourcesHandler;
    private final Collector runResponseCollector;
    private final Collector pullAllResponseCollector;
    private final Queue<Record> recordBuffer = new LinkedList<Record>();
    private List<String> keys = null;
    private ResultSummary summary = null;
    private boolean done = false;

    InternalStatementResult(Connection connection, SessionResourcesHandler resourcesHandler, ExplicitTransaction transaction, Statement statement) {
        this.connection = connection;
        this.runResponseCollector = this.newRunResponseCollector();
        this.pullAllResponseCollector = this.newStreamResponseCollector(transaction, statement, connection.server());
        this.resourcesHandler = resourcesHandler;
    }

    private Collector newRunResponseCollector() {
        return new Collector.NoOperationCollector(){

            @Override
            public void keys(String[] names) {
                InternalStatementResult.this.keys = Arrays.asList(names);
            }

            @Override
            public void done() {
                if (InternalStatementResult.this.keys == null) {
                    InternalStatementResult.this.keys = new ArrayList();
                }
            }

            @Override
            public void resultAvailableAfter(long l) {
                InternalStatementResult.this.pullAllResponseCollector.resultAvailableAfter(l);
            }
        };
    }

    private Collector newStreamResponseCollector(final ExplicitTransaction transaction, Statement statement, ServerInfo serverInfo) {
        final SummaryBuilder summaryBuilder = new SummaryBuilder(statement, serverInfo);
        return new Collector.NoOperationCollector(){

            @Override
            public void record(Value[] fields) {
                InternalStatementResult.this.recordBuffer.add(new InternalRecord(InternalStatementResult.this.keys, fields));
            }

            @Override
            public void statementType(StatementType type) {
                summaryBuilder.statementType(type);
            }

            @Override
            public void statementStatistics(SummaryCounters statistics) {
                summaryBuilder.statementStatistics(statistics);
            }

            @Override
            public void plan(Plan plan) {
                summaryBuilder.plan(plan);
            }

            @Override
            public void profile(ProfiledPlan plan) {
                summaryBuilder.profile(plan);
            }

            @Override
            public void notifications(List<Notification> notifications) {
                summaryBuilder.notifications(notifications);
            }

            @Override
            public void bookmark(String bookmark) {
                if (transaction != null) {
                    transaction.setBookmark(bookmark);
                }
            }

            @Override
            public void done() {
                InternalStatementResult.this.summary = summaryBuilder.build();
                InternalStatementResult.this.done = true;
            }

            @Override
            public void resultAvailableAfter(long l) {
                summaryBuilder.resultAvailableAfter(l);
            }

            @Override
            public void resultConsumedAfter(long l) {
                summaryBuilder.resultConsumedAfter(l);
            }
        };
    }

    Collector runResponseCollector() {
        return this.runResponseCollector;
    }

    Collector pullAllResponseCollector() {
        return this.pullAllResponseCollector;
    }

    @Override
    public List<String> keys() {
        if (this.keys == null) {
            this.tryFetchNext();
        }
        return this.keys;
    }

    @Override
    public boolean hasNext() {
        return this.tryFetchNext();
    }

    @Override
    public Record next() {
        if (this.tryFetchNext()) {
            return this.recordBuffer.poll();
        }
        throw new NoSuchRecordException("No more records");
    }

    @Override
    public Record single() {
        if (this.hasNext()) {
            Record single = this.next();
            boolean hasMoreThanOne = this.hasNext();
            this.consume();
            if (hasMoreThanOne) {
                throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record, or use `first` instead of `single` if you do not care about the number of records in the result.");
            }
            return single;
        }
        throw new NoSuchRecordException("Cannot retrieve a single record, because this result is empty.");
    }

    @Override
    public Record peek() {
        if (this.tryFetchNext()) {
            return this.recordBuffer.peek();
        }
        throw new NoSuchRecordException("Cannot peek past the last record");
    }

    @Override
    public List<Record> list() {
        return this.list(Functions.identity());
    }

    @Override
    public <T> List<T> list(Function<Record, T> mapFunction) {
        if (this.hasNext()) {
            ArrayList<T> result = new ArrayList<T>();
            do {
                result.add(mapFunction.apply(this.next()));
            } while (this.hasNext());
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public ResultSummary consume() {
        if (this.done) {
            this.recordBuffer.clear();
        } else {
            do {
                this.receiveOne();
                this.recordBuffer.clear();
            } while (!this.done);
        }
        return this.summary;
    }

    @Override
    public ResultSummary summary() {
        while (!this.done) {
            this.receiveOne();
        }
        return this.summary;
    }

    @Override
    public void remove() {
        throw new ClientException("Removing records from a result is not supported.");
    }

    private boolean tryFetchNext() {
        while (this.recordBuffer.isEmpty()) {
            if (this.done) {
                return false;
            }
            this.receiveOne();
        }
        return true;
    }

    private void receiveOne() {
        try {
            this.connection.receiveOne();
        }
        catch (Throwable error) {
            this.resourcesHandler.onResultConsumed();
            throw error;
        }
        if (this.done) {
            this.resourcesHandler.onResultConsumed();
        }
    }
}

