/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Set;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.GetServersProcedureClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoundRobinAddressSet;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.exceptions.ProtocolException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class LoadBalancer
implements RoutingErrorHandler,
AutoCloseable {
    private final Logger log;
    private final ConnectionPool connections;
    private final RoutingTable routingTable;
    private final Rediscovery rediscovery;

    public LoadBalancer(RoutingSettings settings, Clock clock, Logger log, ConnectionPool connections, BoltServerAddress ... routingAddresses) throws ServiceUnavailableException {
        this(settings, clock, log, connections, new ClusterRoutingTable(clock, routingAddresses), new GetServersProcedureClusterCompositionProvider(clock, log));
    }

    private LoadBalancer(RoutingSettings settings, Clock clock, Logger log, ConnectionPool connections, RoutingTable routingTable, ClusterCompositionProvider provider) throws ServiceUnavailableException {
        this(routingTable, connections, new Rediscovery(settings, clock, log, provider), log);
    }

    LoadBalancer(RoutingTable routingTable, ConnectionPool connections, Rediscovery rediscovery, Logger log) throws ServiceUnavailableException {
        this.log = log;
        this.connections = connections;
        this.routingTable = routingTable;
        this.rediscovery = rediscovery;
        this.ensureRouting();
    }

    public Connection acquireReadConnection() throws ServiceUnavailableException {
        return this.acquireConnection(this.routingTable.readers());
    }

    public Connection acquireWriteConnection() throws ServiceUnavailableException {
        return this.acquireConnection(this.routingTable.writers());
    }

    @Override
    public void onConnectionFailure(BoltServerAddress address) {
        this.forget(address);
    }

    @Override
    public void onWriteFailure(BoltServerAddress address) {
        this.routingTable.removeWriter(address);
    }

    @Override
    public void close() throws Exception {
        this.connections.close();
    }

    private Connection acquireConnection(RoundRobinAddressSet servers) throws ServiceUnavailableException {
        block2: while (true) {
            this.ensureRouting();
            while (true) {
                BoltServerAddress address;
                if ((address = servers.next()) == null) continue block2;
                try {
                    return this.connections.acquire(address);
                }
                catch (ServiceUnavailableException e) {
                    this.log.error(String.format("Failed to refresh routing information using routing address %s", address), e);
                    this.forget(address);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private synchronized void forget(BoltServerAddress address) {
        this.routingTable.forget(address);
        this.connections.purge(address);
    }

    synchronized void ensureRouting() throws ServiceUnavailableException, ProtocolException {
        if (this.routingTable.isStale()) {
            this.log.info("Routing information is stale. %s", this.routingTable);
            try {
                ClusterComposition cluster = this.rediscovery.lookupRoutingTable(this.connections, this.routingTable);
                Set<BoltServerAddress> removed = this.routingTable.update(cluster);
                for (BoltServerAddress address : removed) {
                    this.connections.purge(address);
                }
                this.log.info("Refreshed routing information. %s", this.routingTable);
            }
            catch (InterruptedException e) {
                throw new ServiceUnavailableException("Thread was interrupted while establishing connection.", e);
            }
        }
    }
}

