/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.RoundRobinAddressSet;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.util.Clock;

public class ClusterRoutingTable
implements RoutingTable {
    private static final int MIN_ROUTERS = 1;
    private final Clock clock;
    private long expirationTimeout;
    private final RoundRobinAddressSet readers;
    private final RoundRobinAddressSet writers;
    private final RoundRobinAddressSet routers;

    public ClusterRoutingTable(Clock clock, BoltServerAddress ... routingAddresses) {
        this(clock);
        this.routers.update(new HashSet<BoltServerAddress>(Arrays.asList(routingAddresses)), new HashSet<BoltServerAddress>());
    }

    private ClusterRoutingTable(Clock clock) {
        this.clock = clock;
        this.expirationTimeout = clock.millis() - 1L;
        this.readers = new RoundRobinAddressSet();
        this.writers = new RoundRobinAddressSet();
        this.routers = new RoundRobinAddressSet();
    }

    @Override
    public boolean isStale() {
        return this.expirationTimeout < this.clock.millis() || this.routers.size() <= 1 || this.readers.size() == 0 || this.writers.size() == 0;
    }

    @Override
    public synchronized Set<BoltServerAddress> update(ClusterComposition cluster) {
        this.expirationTimeout = cluster.expirationTimestamp();
        HashSet<BoltServerAddress> removed = new HashSet<BoltServerAddress>();
        this.readers.update(cluster.readers(), removed);
        this.writers.update(cluster.writers(), removed);
        this.routers.update(cluster.routers(), removed);
        return removed;
    }

    @Override
    public synchronized void forget(BoltServerAddress address) {
        this.readers.remove(address);
        this.writers.remove(address);
    }

    @Override
    public RoundRobinAddressSet readers() {
        return this.readers;
    }

    @Override
    public RoundRobinAddressSet writers() {
        return this.writers;
    }

    @Override
    public BoltServerAddress nextRouter() {
        return this.routers.next();
    }

    @Override
    public int routerSize() {
        return this.routers.size();
    }

    @Override
    public void removeWriter(BoltServerAddress toRemove) {
        this.writers.remove(toRemove);
    }

    @Override
    public void removeRouter(BoltServerAddress toRemove) {
        this.routers.remove(toRemove);
    }

    public String toString() {
        return String.format("Ttl %s, currentTime %s, routers %s, writers %s, readers %s", this.expirationTimeout, this.clock.millis(), this.routers, this.writers, this.readers);
    }
}

