/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.BaseDriver;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;

public class DirectDriver
extends BaseDriver {
    private final BoltServerAddress address;
    protected final ConnectionPool connections;

    public DirectDriver(BoltServerAddress address, ConnectionPool connections, SecurityPlan securityPlan, SessionFactory sessionFactory, Logging logging) {
        super(securityPlan, sessionFactory, logging);
        this.address = address;
        this.connections = connections;
    }

    @Override
    protected Session newSessionWithMode(AccessMode mode) {
        return this.sessionFactory.newInstance(this.connections.acquire(this.address));
    }

    @Override
    protected void closeResources() {
        try {
            this.connections.close();
        }
        catch (Exception ex) {
            this.log.error(String.format("~~ [ERROR] %s", ex.getMessage()), ex);
        }
    }

    BoltServerAddress server() {
        return this.address;
    }
}

