/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DirectDriver;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.RoutingDriver;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.pooling.PoolSettings;
import org.neo4j.driver.internal.net.pooling.SocketConnectionPool;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.util.Function;

public class GraphDatabase {
    private static final Function<Connection, Session> SESSION_PROVIDER = new Function<Connection, Session>(){

        @Override
        public Session apply(Connection connection) {
            return new NetworkSession(connection);
        }
    };

    public static Driver driver(String uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri, Config config) {
        return GraphDatabase.driver(uri, AuthTokens.none(), config);
    }

    public static Driver driver(String uri, Config config) {
        return GraphDatabase.driver(URI.create(uri), config);
    }

    public static Driver driver(String uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(URI uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(String uri, AuthToken authToken, Config config) {
        return GraphDatabase.driver(URI.create(uri), authToken, config);
    }

    public static Driver driver(URI uri, AuthToken authToken, Config config) {
        SecurityPlan securityPlan;
        String scheme = uri.getScheme();
        BoltServerAddress address = BoltServerAddress.from(uri);
        ConnectionSettings connectionSettings = new ConnectionSettings(authToken == null ? AuthTokens.none() : authToken);
        if (config == null) {
            config = Config.defaultConfig();
        }
        try {
            securityPlan = GraphDatabase.createSecurityPlan(address, config);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new ClientException("Unable to establish SSL parameters", ex);
        }
        PoolSettings poolSettings = new PoolSettings(config.maxIdleConnectionPoolSize());
        SocketConnectionPool connectionPool = new SocketConnectionPool(connectionSettings, securityPlan, poolSettings, config.logging());
        switch (scheme.toLowerCase()) {
            case "bolt": {
                return new DirectDriver(address, connectionPool, securityPlan, config.logging());
            }
            case "bolt+routing": {
                return new RoutingDriver(config.routingSettings(), address, connectionPool, securityPlan, Clock.SYSTEM, config.logging());
            }
        }
        throw new ClientException(String.format("Unsupported URI scheme: %s", scheme));
    }

    private static SecurityPlan createSecurityPlan(BoltServerAddress address, Config config) throws GeneralSecurityException, IOException {
        Config.EncryptionLevel encryptionLevel = config.encryptionLevel();
        boolean requiresEncryption = encryptionLevel.equals((Object)Config.EncryptionLevel.REQUIRED);
        if (requiresEncryption) {
            Logger logger = config.logging().getLog("session");
            switch (config.trustStrategy().strategy()) {
                case TRUST_ON_FIRST_USE: {
                    logger.warn("Option `TRUST_ON_FIRST_USE` has been deprecated and will be removed in a future version of the driver. Please switch to use `TRUST_ALL_CERTIFICATES` instead.", new Object[0]);
                    return SecurityPlan.forTrustOnFirstUse(config.trustStrategy().certFile(), address, logger);
                }
                case TRUST_SIGNED_CERTIFICATES: {
                    logger.warn("Option `TRUST_SIGNED_CERTIFICATE` has been deprecated and will be removed in a future version of the driver. Please switch to use `TRUST_CUSTOM_CA_SIGNED_CERTIFICATES` instead.", new Object[0]);
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlan.forCustomCASignedCertificates(config.trustStrategy().certFile());
                }
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlan.forSystemCASignedCertificates();
                }
                case TRUST_ALL_CERTIFICATES: {
                    return SecurityPlan.forAllCertificates();
                }
            }
            throw new ClientException("Unknown TLS authentication strategy: " + config.trustStrategy().strategy().name());
        }
        return SecurityPlan.insecure();
    }
}

