/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.types.InternalMapAccessorWithDefaultValue;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.types.TypeRepresentation;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.value.NotMultiValued;
import org.neo4j.driver.v1.exceptions.value.Uncoercible;
import org.neo4j.driver.v1.exceptions.value.Unsizable;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.driver.v1.types.Type;
import org.neo4j.driver.v1.util.Function;

public abstract class ValueAdapter
extends InternalMapAccessorWithDefaultValue
implements InternalValue {
    @Override
    public Value asValue() {
        return this;
    }

    @Override
    public boolean hasType(Type type) {
        return type.isTypeOf(this);
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean containsKey(String key) {
        throw new NotMultiValued(this.type().name() + " is not a keyed collection");
    }

    @Override
    public String asString() {
        throw new Uncoercible(this.type().name(), "Java String");
    }

    public String asLiteralString() {
        throw new Uncoercible(this.type().name(), "Java String representation of Cypher literal");
    }

    @Override
    public long asLong() {
        throw new Uncoercible(this.type().name(), "Java long");
    }

    @Override
    public int asInt() {
        throw new Uncoercible(this.type().name(), "Java int");
    }

    @Override
    public float asFloat() {
        throw new Uncoercible(this.type().name(), "Java float");
    }

    @Override
    public double asDouble() {
        throw new Uncoercible(this.type().name(), "Java double");
    }

    @Override
    public boolean asBoolean() {
        throw new Uncoercible(this.type().name(), "Java boolean");
    }

    @Override
    public List<Object> asList() {
        return this.asList(Values.ofObject());
    }

    @Override
    public <T> List<T> asList(Function<Value, T> mapFunction) {
        throw new Uncoercible(this.type().name(), "Java List");
    }

    @Override
    public Map<String, Object> asMap() {
        return this.asMap(Values.ofObject());
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapFunction) {
        throw new Uncoercible(this.type().name(), "Java Map");
    }

    @Override
    public Object asObject() {
        throw new Uncoercible(this.type().name(), "Java Object");
    }

    @Override
    public Number asNumber() {
        throw new Uncoercible(this.type().name(), "Java Number");
    }

    @Override
    public Entity asEntity() {
        throw new Uncoercible(this.type().name(), "Entity");
    }

    @Override
    public Node asNode() {
        throw new Uncoercible(this.type().name(), "Node");
    }

    @Override
    public Path asPath() {
        throw new Uncoercible(this.type().name(), "Path");
    }

    @Override
    public Relationship asRelationship() {
        throw new Uncoercible(this.type().name(), "Relationship");
    }

    @Override
    public Value get(int index) {
        throw new NotMultiValued(this.type().name() + " is not an indexed collection");
    }

    @Override
    public Value get(String key) {
        throw new NotMultiValued(this.type().name() + " is not a keyed collection");
    }

    @Override
    public int size() {
        throw new Unsizable(this.type().name() + " does not have size");
    }

    @Override
    public Iterable<String> keys() {
        return Collections.emptyList();
    }

    @Override
    public boolean isEmpty() {
        return !this.values().iterator().hasNext();
    }

    @Override
    public Iterable<Value> values() {
        return this.values(Values.ofValue());
    }

    @Override
    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        throw new NotMultiValued(this.type().name() + " is not iterable");
    }

    @Override
    public String toString() {
        return this.toString(InternalValue.Format.VALUE_ONLY);
    }

    protected String maybeWithType(boolean includeType, String text) {
        return includeType ? this.withType(text) : text;
    }

    private String withType(String text) {
        return String.format("%s :: %s", text, this.type().name());
    }

    @Override
    public final TypeConstructor typeConstructor() {
        return ((TypeRepresentation)this.type()).constructor();
    }
}

