/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.net.pooling.PooledConnection;
import org.neo4j.driver.internal.util.Supplier;

public class BlockingPooledConnectionQueue {
    private final BlockingQueue<PooledConnection> queue;
    private final AtomicBoolean isTerminating = new AtomicBoolean(false);
    private final Set<PooledConnection> acquiredConnections = Collections.newSetFromMap(new ConcurrentHashMap());

    public BlockingPooledConnectionQueue(int capacity) {
        this.queue = new LinkedBlockingQueue<PooledConnection>(capacity);
    }

    public boolean offer(PooledConnection pooledConnection) {
        PooledConnection poll;
        this.acquiredConnections.remove(pooledConnection);
        boolean offer = this.queue.offer(pooledConnection);
        if (!offer) {
            pooledConnection.dispose();
        }
        if (this.isTerminating.get() && (poll = (PooledConnection)this.queue.poll()) != null) {
            poll.dispose();
        }
        return offer;
    }

    public PooledConnection acquire(Supplier<PooledConnection> supplier) {
        PooledConnection poll = (PooledConnection)this.queue.poll();
        if (poll == null) {
            poll = supplier.get();
        }
        this.acquiredConnections.add(poll);
        if (this.isTerminating.get()) {
            this.acquiredConnections.remove(poll);
            poll.dispose();
            throw new IllegalStateException("Pool has been closed, cannot acquire new values.");
        }
        return poll;
    }

    public List<PooledConnection> toList() {
        return new ArrayList<PooledConnection>(this.queue);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public boolean contains(PooledConnection pooledConnection) {
        return this.queue.contains(pooledConnection);
    }

    public void terminate() {
        if (this.isTerminating.compareAndSet(false, true)) {
            while (!this.queue.isEmpty()) {
                PooledConnection conn = (PooledConnection)this.queue.poll();
                if (conn == null) continue;
                conn.dispose();
            }
            for (PooledConnection pooledConnection : this.acquiredConnections) {
                pooledConnection.dispose();
            }
        }
    }
}

