/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;

public class BoltServerAddress {
    public static final int DEFAULT_PORT = 7687;
    public static final BoltServerAddress LOCAL_DEFAULT = new BoltServerAddress("localhost", 7687);
    private final String host;
    private final int port;
    private SocketAddress socketAddress = null;

    public static BoltServerAddress from(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = 7687;
        }
        return new BoltServerAddress(uri.getHost(), port);
    }

    public BoltServerAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public BoltServerAddress(String host) {
        int colon = host.indexOf(58);
        if (colon >= 0) {
            this.port = Integer.parseInt(host.substring(colon + 1));
            this.host = host.substring(0, colon);
        } else {
            this.host = host;
            this.port = 7687;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BoltServerAddress)) {
            return false;
        }
        BoltServerAddress address = (BoltServerAddress)obj;
        return this.host.equals(address.host) && this.port == address.port;
    }

    public int hashCode() {
        return 31 * this.host.hashCode() + this.port;
    }

    public String toString() {
        return String.format("%s:%d", this.host, this.port);
    }

    public SocketAddress toSocketAddress() {
        if (this.socketAddress == null) {
            this.socketAddress = new InetSocketAddress(this.host, this.port);
        }
        return this.socketAddress;
    }

    public BoltServerAddress resolve() throws UnknownHostException {
        String hostAddress = InetAddress.getByName(this.host).getHostAddress();
        if (hostAddress.equals(this.host)) {
            return this;
        }
        return new BoltServerAddress(hostAddress, this.port);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }
}

