/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.net.pooling.PooledConnection;
import org.neo4j.driver.internal.util.Consumer;
import org.neo4j.driver.v1.util.Function;

class PooledConnectionReleaseConsumer
implements Consumer<PooledConnection> {
    private final BlockingQueue<PooledConnection> connections;
    private final AtomicBoolean driverStopped;
    private final Function<PooledConnection, Boolean> validConnection;

    PooledConnectionReleaseConsumer(BlockingQueue<PooledConnection> connections, AtomicBoolean driverStopped, Function<PooledConnection, Boolean> validConnection) {
        this.connections = connections;
        this.driverStopped = driverStopped;
        this.validConnection = validConnection;
    }

    @Override
    public void accept(PooledConnection pooledConnection) {
        if (this.driverStopped.get()) {
            pooledConnection.dispose();
        } else if (this.validConnection.apply(pooledConnection).booleanValue()) {
            PooledConnection conn;
            boolean released = this.connections.offer(pooledConnection);
            if (!released) {
                pooledConnection.dispose();
            } else if (this.driverStopped.get() && (conn = (PooledConnection)this.connections.poll()) != null) {
                conn.dispose();
            }
        } else {
            pooledConnection.dispose();
        }
    }
}

