/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.RoutingNetworkSession;
import org.neo4j.driver.internal.RoutingStatementResult;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ConnectionFailureException;
import org.neo4j.driver.v1.types.TypeSystem;

public class RoutingTransaction
implements Transaction {
    protected final Transaction delegate;
    private final AccessMode mode;
    private final BoltServerAddress address;
    private final RoutingErrorHandler onError;

    RoutingTransaction(Transaction delegate, AccessMode mode, BoltServerAddress address, RoutingErrorHandler onError) {
        this.delegate = delegate;
        this.mode = mode;
        this.address = address;
        this.onError = onError;
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public StatementResult run(Statement statement) {
        try {
            return new RoutingStatementResult(this.delegate.run(statement), this.mode, this.address, this.onError);
        }
        catch (ConnectionFailureException e) {
            throw RoutingNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw RoutingNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }

    @Override
    public TypeSystem typeSystem() {
        return this.delegate.typeSystem();
    }

    @Override
    public void success() {
        this.delegate.success();
    }

    @Override
    public void failure() {
        this.delegate.failure();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (ConnectionFailureException e) {
            throw RoutingNetworkSession.sessionExpired(e, this.onError, this.address);
        }
        catch (ClientException e) {
            throw RoutingNetworkSession.filterFailureToWrite(e, this.mode, this.onError, this.address);
        }
    }
}

