/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.packstream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.packstream.PackStream;

public class BufferedChannelInput
implements PackInput {
    private final ByteBuffer buffer;
    private ReadableByteChannel channel;
    private static final int DEFAULT_BUFFER_CAPACITY = 8192;

    public BufferedChannelInput(ReadableByteChannel ch) {
        this(8192, ch);
    }

    public BufferedChannelInput(int bufferCapacity, ReadableByteChannel ch) {
        this.buffer = ByteBuffer.allocate(bufferCapacity).order(ByteOrder.BIG_ENDIAN);
        this.reset(ch);
    }

    public BufferedChannelInput reset(ReadableByteChannel ch) {
        this.channel = ch;
        this.buffer.position(0);
        this.buffer.limit(0);
        return this;
    }

    @Override
    public boolean hasMoreData() throws IOException {
        return this.attempt(1);
    }

    @Override
    public byte readByte() throws IOException {
        this.ensure(1);
        return this.buffer.get();
    }

    @Override
    public short readShort() throws IOException {
        this.ensure(2);
        return this.buffer.getShort();
    }

    @Override
    public int readInt() throws IOException {
        this.ensure(4);
        return this.buffer.getInt();
    }

    @Override
    public long readLong() throws IOException {
        this.ensure(8);
        return this.buffer.getLong();
    }

    @Override
    public double readDouble() throws IOException {
        this.ensure(8);
        return this.buffer.getDouble();
    }

    @Override
    public PackInput readBytes(byte[] into, int index, int toRead) throws IOException {
        int endIndex = index + toRead;
        while (index < endIndex) {
            toRead = Math.min(this.buffer.remaining(), endIndex - index);
            this.buffer.get(into, index, toRead);
            if (this.buffer.remaining() != 0 || (index += toRead) >= endIndex) continue;
            this.attempt(endIndex - index);
            if (this.buffer.remaining() != 0) continue;
            throw new PackStream.EndOfStream("Expected " + (endIndex - index) + " bytes available, " + "but no more bytes accessible from underlying stream.");
        }
        return this;
    }

    @Override
    public byte peekByte() throws IOException {
        this.ensure(1);
        return this.buffer.get(this.buffer.position());
    }

    private boolean attempt(int numBytes) throws IOException {
        int count;
        if (this.buffer.remaining() >= numBytes) {
            return true;
        }
        if (this.buffer.remaining() > 0) {
            this.buffer.compact();
        } else {
            this.buffer.clear();
        }
        while ((count = this.channel.read(this.buffer)) >= 0 && this.buffer.position() < numBytes && this.buffer.remaining() != 0) {
        }
        this.buffer.flip();
        return this.buffer.remaining() >= numBytes;
    }

    private void ensure(int numBytes) throws IOException {
        if (!this.attempt(numBytes)) {
            throw new PackStream.EndOfStream("Unexpected end of stream while trying to read " + numBytes + " bytes.");
        }
    }
}

