/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.BaseDriver;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;

public class DirectDriver
extends BaseDriver {
    protected final ConnectionPool connections;
    private final BoltServerAddress address;

    public DirectDriver(BoltServerAddress address, ConnectionPool connections, SecurityPlan securityPlan, Logging logging) {
        super(securityPlan, logging);
        this.connections = connections;
        this.address = address;
    }

    @Override
    public Session session() {
        return new NetworkSession(this.connections.acquire(this.address));
    }

    @Override
    public Session session(AccessMode ignore) {
        return this.session();
    }

    @Override
    public void close() {
        try {
            this.connections.close();
        }
        catch (Exception ex) {
            this.log.error(String.format("~~ [ERROR] %s", ex.getMessage()), ex);
        }
    }

    BoltServerAddress server() {
        return this.address;
    }
}

